package com.pcloud.book.es.entity;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2020/4/13 14:29
 **/
@Data
public class ESBookAndAdviser  {


    /**
     * 书籍标识
     */
    private String bookId;

    /**
     * 编辑书id
     */
    private String bookAdviserId;

    /**
     * 编辑标识
     */
    private String adviserId;

    /**
     * 渠道标识
     */
    private String channelId;

    /**
     * 模板标识
     */
    private String templetId;

    /**
     * 第二级类型
     */
    private String secondTempletId;

    /**
     * 第二级类型
     */
    private String thirdTempletId;

    /**
     * 是否是主编辑
     */
    private Boolean isMainEditor;

    /**
     * 类型编码
     */
    private String typeCode;

    /**
     * 书籍ISBN码
     */
    private String isbn;

    /**
     * 书籍名称
     */
    private String bookName;

    /**
     * 书籍名称，同上面bookName，ES按分词存储，主要用于分词搜索
     */
    private String ikBookName;

    /**
     * 是否删除(书)
     */
    private String isBookDelete;

    /**
     * 是否删除(编辑书)
     */
    private String isBookAdviserDelete;

    /**
     * 最后更新时间
     */
    private Date lastModifiedDate;

    /**
     * 编辑书创建时间
     */
    private Date createdDate;

    /**
     * 是否编辑书刊
     */
    private String isAdviserBook;

    /**
     * 年级标签id
     */
    private Long graLabelId;

    /**
     * 科目标签id
     */
    private Long subLabelId;

    /**
     * 版本标签id
     */
    private Long verLabelId;

    /**
     * 地域标签id
     */
    private Long areaLabelId;
    /**
     * 上下册标签id
     */
    private Long volLabelId;
    /**
     * 社群书id
     */
    private Long bookGroupId;
    /**
     * 社群书类型
     */
    private Integer joinGroupType;
    /**
     * 书刊访问数量
     */
    private Integer bookUserCount;
    /**
     * 书刊资源数量
     */
    private Integer resourceCount;
    /**
     * 是否基金支持
     */
    private Integer isFundSupport;
    /**
     * 基金书访问量公式（GMV*10+扫码*3+浏览量）
     */
    private BigDecimal fundBookValue;
    /**
     * 是否已立项
     */
    private Integer isApproval;
    /**
     * 权益id
     */
    private Long rightsSettingId;
    /**
     * 书刊序号
     */
    private String serialNumber;
    /**
     * 是否配有答案
     */
    private Integer hasAnswer;

    /**
     * 科目
     */
    private String label1;
    /**
     * 年级
     */
    private String label2;
    /**
     * 版本
     */
    private String label3;
    /**
     * 上下册
     */
    private String label4;

}
