package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.ResourcePageModelDao;
import com.pcloud.book.group.entity.ResourcePageModel;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.group.dao.impl.ResourcePageModelDaoImpl
 * @Author zhuyajie
 * @Description 图书标准服务
 * @Date 2022/1/15 15:18
 **/
@Component
public class ResourcePageModelDaoImpl extends BaseDaoImpl<ResourcePageModel> implements ResourcePageModelDao {
    @Override
    public List<ResourcePageModel> getByPaegId(Long resourcePageId) {
        return getSessionTemplate().selectList(getStatement("getByPaegId"), resourcePageId);
    }

    @Override
    public void deleteByPageId(Long resourcePageId) {
        getSessionTemplate().delete(getStatement("deleteByPageId"), resourcePageId);
    }

    @Override
    public void deleteByPageIdAndTypeCode(Long resourcePageId, List<String> typeCodes) {
        Map<String,Object> map = new HashMap<>();
        map.put("resourcePageId", resourcePageId);
        map.put("typeCodes", typeCodes);
        getSessionTemplate().delete(getStatement("deleteByPageIdAndTypeCode"), map);
    }

    @Override
    public void deleteByPageIdExcludeTypeCode(Long resourcePageId, List<String> typeCodes) {
        Map<String,Object> map = new HashMap<>();
        map.put("resourcePageId", resourcePageId);
        map.put("typeCodes", typeCodes);
        getSessionTemplate().delete(getStatement("deleteByPageIdExcludeTypeCode"), map);
    }
}
