package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.ResourcePageWxworkDao;
import com.pcloud.book.group.entity.ResourcePageWxwork;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.group.dao.impl.ResourcePageWxworkDaoImpl
 * @Author zhuyajie
 * @Description 企业微信落地页
 * @Date 2021/12/2 14:32
 **/
@Component
public class ResourcePageWxworkDaoImpl extends BaseDaoImpl<ResourcePageWxwork> implements ResourcePageWxworkDao {
    @Override
    public ResourcePageWxwork getByPageId(Long resourcePageId) {
        return getSessionTemplate().selectOne(getStatement("getByPageId"), resourcePageId);
    }

    @Override
    public List<Long> getWxworkBySceneIds(List<Long> sceneIds) {
        Map<String,Object> map = new HashMap<>();
        map.put("list", sceneIds);
        return getSessionTemplate().selectList(getStatement("getWxworkBySceneIds"), map);
    }
}
