package com.pcloud.book.group.entity;

import java.util.Date;
import java.math.BigDecimal;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.group.dto.MultiChannelContentItemDTO;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * (MultiChannelContent)实体类
 *
 * @author wubo 
 * @since 2022-06-06 19:11:39
 */
@Data
public class MultiChannelContent extends BaseEntity {

    private static final long serialVersionUID = -72951424589096388L;
    
    @ApiModelProperty("主键id")
    private Long id;
    
    @ApiModelProperty("渠道类型 1 抖音")
    private Integer channelType;
    
    @ApiModelProperty("授权用户id")
    private Long userId;
    
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    
    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    private List<MultiChannelContentItemDTO> multiChannelContentItems;
    
}
