package com.pcloud.book.group.facade;

import com.pcloud.book.group.entity.ResourcePageOuterLink;
import com.pcloud.book.group.biz.ResourcePageOuterLinkBiz;
 import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import io.swagger.annotations.ApiOperation;

/**
 * (ResourcePageOuterLink)表控制层
 *
 * @author wubo 
 * @since 2022-05-17 14:14:08
 */
@RestController("resourcePageOuterLinkFacade")
@RequestMapping("resourcePageOuterLink")
public class ResourcePageOuterLinkFacade {
    
    @Autowired
    private ResourcePageOuterLinkBiz resourcePageOuterLinkBiz;

    
    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(resourcePageOuterLinkBiz.getById(id));
    }
    
    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@RequestHeader("token") String token, 
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage, 
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage) 
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(resourcePageOuterLinkBiz.getList(currentPage, numPerPage));
    }
    
    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@RequestHeader("token") String token, @RequestBody ResourcePageOuterLink resourcePageOuterLink)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(resourcePageOuterLinkBiz.insert(resourcePageOuterLink));
    }
    
    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@RequestHeader("token") String token,@RequestBody ResourcePageOuterLink resourcePageOuterLink) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        resourcePageOuterLinkBiz.update(resourcePageOuterLink);
        return new ResponseDto<>();
    }
    
    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BizException.PARAM_DELETION;
        }
        resourcePageOuterLinkBiz.deleteById(id);
        return new ResponseDto<>();
    }
    
    @ApiOperation("软删除")
    @GetMapping("softDeleteById")
    public ResponseDto<?> softDeleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BizException.PARAM_DELETION;
        }
        resourcePageOuterLinkBiz.softDeleteById(id);
        return new ResponseDto<>();
    }

}
