package com.pcloud.book.group.vo;

import com.pcloud.advertising.advertising.dto.AdvertisingSpaceItemDTO;
import com.pcloud.common.dto.BaseDto;

import java.util.List;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName com.pcloud.book.group.vo.UpdateResourceColumnVO
 * @Author zhuyajie
 * @Description 资源页栏目
 * @Date 2021/3/26 17:17
 * @Version 1.0
 **/
@Data
public class ResourceColumnAndServeVO extends BaseDto{
    /**
     * 资源页id
     */
    private Long resourcePageId;
    /**
     * 资源栏目id
     */
    private Long resourcePageColumnId;
    /**
     * 栏目类型
     */
    private Integer columnType;
    /**
     * 栏目标题
     */
    private String columnName;
    /**
     * 栏目版式
     */
    private Integer columnFormat;
    /**
     * 栏目排序
     */
    private Integer columnSeq;
    /**
     * 客户端展示数量
     */
    private Integer showCount;
    /**
     * 客户端是否开启展示更多
     */
    private Integer showMore;
    /**
     * 资源列表
     */
    private List<ResourcePageItemVO> itemVOList;
    /**
     * 资源类型
     */
    private String serveType;

    /**
     * 图片位图片
     */
    private String logoUrl;
    /**
     * 标签图标
     */
    private String labelIcon;

    @ApiModelProperty("栏目标识")
    private String columnMarker;

    @ApiModelProperty("是否是广告")
    private Boolean isAdvertising;

    @ApiModelProperty("广告主id")
    private Long masterId;

    @ApiModelProperty("广告位ID")
    private Long advertisingSpaceId;

    @ApiModelProperty("广告详情id")
    private Long advertisingSpaceItemId;

    @ApiModelProperty("广告位置")
    private String adPosition;

    @ApiModelProperty("广告位置")
    private Integer themeStyle;

    @ApiModelProperty("广告配置项信息")
    private List<AdvertisingSpaceItemDTO> advertisingItemList;

    /**
     * 导航id
     */
    private Long navigationId;

    /**
     * 背景图类型
     */
    private Integer backgroundType;

    /**
     * 背景图地址
     */
    private String backgroundUrl;
}
