package com.pcloud.book.recommend.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 基于资源的推荐(ResourceRecommend)实体类
 *
 * @author makejava
 * @since 2021-10-29 15:22:48
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ResourceRecommend extends BaseEntity {

    private static final long serialVersionUID = 910936933680168511L;
    
    @ApiModelProperty("编辑id")
    private Long adviserId;
    
    @ApiModelProperty("应用或作品id")
    private Integer productOrAppId;
    
    @ApiModelProperty("服务类型")
    private String serverType;
    
    @ApiModelProperty("商品来源")
    private Integer resourceLimitType;
    
    @ApiModelProperty("推荐id集合")
    private String recommendList;
    
    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    
}