package com.pcloud.book.skill.service.impl;

import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.dto.GroupActivity4AppletDTO;
import com.pcloud.book.skill.biz.PcloudGroupActivityBiz;
import com.pcloud.book.skill.biz.PcloudSubRemindBiz;
import com.pcloud.book.skill.service.SkillService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;


@RestController("skillService")
@RequestMapping("skillService")
public class SkillServiceImpl implements SkillService {

    @Autowired
    private PcloudSubRemindBiz pcloudSubRemindBiz;
    @Autowired
    private PcloudGroupActivityBiz pcloudGroupActivityBiz;

    @Override
    @GetMapping("skillRemindMessage")
    public void skillRemindMessage() {
       /* new Thread(() -> {
            pcloudSubRemindBiz.sendTimeTaskMessage();
        }).start();*/
    }

    @Override
    @PostMapping("getGroupByIds")
    public ResponseEntity<ResponseDto<Map<Long, GroupActivity4AppletDTO>>> getGroupByIds(@RequestBody List<Long> bookGroupClassifyIds, @RequestParam("groupType") Integer groupType) {
        return ResponseHandleUtil.toResponse(pcloudGroupActivityBiz.getByIds4NowRecord(bookGroupClassifyIds, groupType));
    }
}
