package com.pcloud.book.timecontrol.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.timecontrol.entity.TimeControlWeekDay;
import java.util.Date;
import java.util.List;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description：TODO
 * @Author：zcy
 * @Date：2020-01-31
 * @Version：1.0
 */
@Data
public class ReplyMessageBaseDto implements Serializable {

    private Integer id;

    private Integer taskId;

    private Integer startDay;

    private String sendHour;

    /**
     * 0-不可配置，1-已配置，2-未配置
     */
    private Integer configState;

    //周次
    private List<TimeControlWeekDay> timeControlWeekDayList;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime;

    //发送方式 /1每天 2每周
    private Integer pushType;

    private  List<Integer> weekdays;
}
