package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletBannerDTO;
import com.pcloud.book.applet.entity.AppletBanner;
import com.pcloud.common.page.PageBeanNew;

/**
 * 小程序banner
 */
public interface AppletBannerBiz {

    /**
     * 新增banner
     * @param appletBanner
     * @return
     */
    Long addBanner(AppletBanner appletBanner);

    /**
     * 修改banner
     * @param appletBanner
     */
    void updateBanner(AppletBanner appletBanner);

    /**
     * 删除banner
     * @param id
     */
    void deleteBanner(Long id);

    /**
     * 根据id查banner
     * @param id
     * @return
     */
    AppletBannerDTO getBannerById(Long id);

    /**
     * banner列表
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletBannerDTO> listBanner(Integer currentPage, Integer numPerPage, Boolean showState, Long agentId);

    /**
     * 客户端banner列表
     * @author：zhuyajie
     * @date：2020/7/17 16:03
     *  * @param null
     */
    PageBeanNew<AppletBannerDTO> listBanner4Wechat(Integer currentPage, Integer numPerPage, Boolean showState, Long officialAccountsId, Long wechatUserId);

    void bannerClickRecord(Long wechatUserId, Long bannerId);
}
