package com.pcloud.book.group.entity;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

/**
 * 社群书群二维码实体
 * @author PENG
 * @date 2019年4月17日11:31:16
 */
public class BookGroup extends BaseEntity {

    private static final long serialVersionUID = 7446049698462097220L;

    /**
     * book_group.id (唯一标识)
     */
    private Long id;

    /**
     * book_group.book_id (书刊ID)
     */
    private Long bookId;

    /**
     * book_group.channel_id (运营ID)
     */
    private Long channelId;

    /**
     * 二维码标识
     */
    private Long sceneId;

    /**
     * book_group.group_qrcode_url (群二维码图片)
     */
    private String groupQrcodeUrl;

    /**
     * book_group.group_qrcode_name (群二维码名称)
     */
    private String groupQrcodeName;

    /**
     * book_group.pro_label_id (专业标签ID)
     */
    private Long proLabelId;

    /**
     * book_group.dep_label_id (深度标签ID)
     */
    private Long depLabelId;

    /**
     * book_group.pur_label_id (目的标签ID)
     */
    private Long purLabelId;

    /**
     * 选择群页面标题
     */
    private String joinTitle;

    /**
     * book_group.join_slogan (进群宣传语)
     */
    private String joinSlogan;

    /**
     * book_group.personal_qrcode_url (个人二维码)
     */
    private String personalQrcodeUrl;

    /**
     * book_group.product_id (商品ID)
     */
    private Long productId;

    /**
     * book_group.create_user (创建人)
     */
    private Long createUser;

    /**
     * book_group.create_time (创建时间)
     */
    private Date createTime;

    /**
     * book_group.update_time (修改时间)
     */
    private Date updateTime;

    /**
     * book_group.is_delete (是否删除)
     */
    private Boolean isDelete;

    /**
     * 是否展示书名
     */
    private Boolean isShowBookName;

    /**
     * 进群方式：1群二维码，2客服机器人
     */
    private Integer joinGroupType;

    /**
     * 加好友欢迎语
     */
    private String addFriendGuide;

    /**
     * 客服称谓
     */
    private String customerServiceName;

    /**
     * 是否邀请入群
     */
    private Boolean isInviteGroup;

    /**
     * 社群书暗号
     */
    private String bookGroupCipher;

    /**
     * 1v1上次推送更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastPushUpdateTime;

    /**
     * 1v1是否在上次推送更新之后有新的更新
     */
    private Boolean isSomeUpdate;

    /**
     * 出版社id
     */
    private Long agentId;

    /**
     * 是否属于特殊出版社
     */
    private Boolean belongSpecialAgent;

    /**
     * 书籍简称
     */
    private String shortBookName;
    /**
     * 是否独立活码群
     */
    private Boolean singleGroup;
    /**
     * 关联群
     */
    private Long relatedBookGroupId;
    /**
     * 好友引导语
     */
    private List<BookGroupFriendGuide> friendGuideList;
    /**
     * 是否开启小睿流程
     */
    private Boolean openWeapp;

    /**
     * 二维码所在页
     * add by pans  2020/7/10
     */
    private Integer groupQrcodePageNum;
    private Integer groupQrcodeLocationId;
    private String groupQrcodeRemark;

    /**
     * 社群码链接
     */
    private String groupQrcodeLink;
    /**
     * 小睿码跳转类型（默认进小睿小程序）
     */
    private Integer jumpType;
    /**
     * 小睿码自定义跳转链接
     */
    private String jumpUrl;

    public Integer getJumpType() {
        return jumpType;
    }

    public void setJumpType(Integer jumpType) {
        this.jumpType = jumpType;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    /**
     * 社群码样式
     */
    private Integer backgroundType;

    /**
     * 二维码样色样式
     */
    private GroupQrcodeStyle groupQrcodeStyle;

    /**
     * 微信选择颜色生成的原始码地址
     */
    private String originUrl;

    public String getOriginUrl() {
        return originUrl;
    }

    public void setOriginUrl(String originUrl) {
        this.originUrl = originUrl;
    }

    public GroupQrcodeStyle getGroupQrcodeStyle() {
        return groupQrcodeStyle;
    }

    public void setGroupQrcodeStyle(GroupQrcodeStyle groupQrcodeStyle) {
        this.groupQrcodeStyle = groupQrcodeStyle;
    }

    public Integer getBackgroundType() {
        return backgroundType;
    }

    public void setBackgroundType(Integer backgroundType) {
        this.backgroundType = backgroundType;
    }

    public String getGroupQrcodeLink() {
        return groupQrcodeLink;
    }

    public void setGroupQrcodeLink(String groupQrcodeLink) {
        this.groupQrcodeLink = groupQrcodeLink;
    }

    public Long getRelatedBookGroupId() {
        return relatedBookGroupId;
    }

    public void setRelatedBookGroupId(Long relatedBookGroupId) {
        this.relatedBookGroupId = relatedBookGroupId;
    }

    public Boolean getSingleGroup() {
        return singleGroup;
    }

    public void setSingleGroup(Boolean singleGroup) {
        this.singleGroup = singleGroup;
    }

    public Boolean getOpenWeapp() {
        return openWeapp;
    }

    public void setOpenWeapp(Boolean openWeapp) {
        this.openWeapp = openWeapp;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getGroupQrcodeUrl() {
        return groupQrcodeUrl;
    }

    public void setGroupQrcodeUrl(String groupQrcodeUrl) {
        this.groupQrcodeUrl = groupQrcodeUrl;
    }

    public String getGroupQrcodeName() {
        return groupQrcodeName;
    }

    public void setGroupQrcodeName(String groupQrcodeName) {
        this.groupQrcodeName = groupQrcodeName;
    }

    public Long getProLabelId() {
        return proLabelId;
    }

    public void setProLabelId(Long proLabelId) {
        this.proLabelId = proLabelId;
    }

    public Long getDepLabelId() {
        return depLabelId;
    }

    public void setDepLabelId(Long depLabelId) {
        this.depLabelId = depLabelId;
    }

    public Long getPurLabelId() {
        return purLabelId;
    }

    public void setPurLabelId(Long purLabelId) {
        this.purLabelId = purLabelId;
    }

    public String getJoinTitle() {
        return joinTitle;
    }

    public void setJoinTitle(String joinTitle) {
        this.joinTitle = joinTitle;
    }

    public String getJoinSlogan() {
        return joinSlogan;
    }

    public void setJoinSlogan(String joinSlogan) {
        this.joinSlogan = joinSlogan;
    }

    public String getPersonalQrcodeUrl() {
        return personalQrcodeUrl;
    }

    public void setPersonalQrcodeUrl(String personalQrcodeUrl) {
        this.personalQrcodeUrl = personalQrcodeUrl;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public Long getSceneId() {
        return sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    public Boolean getIsShowBookName() {
        return isShowBookName;
    }

    public void setIsShowBookName(Boolean isShowBookName) {
        this.isShowBookName = isShowBookName;
    }

    public Integer getJoinGroupType() {
        return joinGroupType;
    }

    public void setJoinGroupType(Integer joinGroupType) {
        this.joinGroupType = joinGroupType;
    }

    public String getAddFriendGuide() {
        return addFriendGuide;
    }

    public void setAddFriendGuide(String addFriendGuide) {
        this.addFriendGuide = addFriendGuide;
    }

    public String getCustomerServiceName() {
        return customerServiceName;
    }

    public void setCustomerServiceName(String customerServiceName) {
        this.customerServiceName = customerServiceName;
    }

    public Boolean getIsInviteGroup() {
        return isInviteGroup;
    }

    public void setIsInviteGroup(Boolean isInviteGroup) {
        this.isInviteGroup = isInviteGroup;
    }

    public String getBookGroupCipher() {
        return bookGroupCipher;
    }

    public void setBookGroupCipher(String bookGroupCipher) {
        this.bookGroupCipher = bookGroupCipher;
    }

    public Date getLastPushUpdateTime() {
        return lastPushUpdateTime;
    }

    public void setLastPushUpdateTime(Date lastPushUpdateTime) {
        this.lastPushUpdateTime = lastPushUpdateTime;
    }

    public Boolean getIsSomeUpdate() {
        return isSomeUpdate;
    }

    public void setIsSomeUpdate(Boolean isSomeUpdate) {
        this.isSomeUpdate = isSomeUpdate;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public Boolean getBelongSpecialAgent() {
        return belongSpecialAgent;
    }

    public void setBelongSpecialAgent(Boolean belongSpecialAgent) {
        this.belongSpecialAgent = belongSpecialAgent;
    }

    public String getShortBookName() {
        return shortBookName;
    }

    public void setShortBookName(String shortBookName) {
        this.shortBookName = shortBookName;
    }

    public List<BookGroupFriendGuide> getFriendGuideList() {
        return friendGuideList;
    }

    public void setFriendGuideList(List<BookGroupFriendGuide> friendGuideList) {
        this.friendGuideList = friendGuideList;
    }

    public Integer getGroupQrcodePageNum() {
        return groupQrcodePageNum;
    }

    public void setGroupQrcodePageNum(Integer groupQrcodePageNum) {
        this.groupQrcodePageNum = groupQrcodePageNum;
    }

    public Integer getGroupQrcodeLocationId() {
        return groupQrcodeLocationId;
    }

    public void setGroupQrcodeLocationId(Integer groupQrcodeLocationId) {
        this.groupQrcodeLocationId = groupQrcodeLocationId;
    }

    public String getGroupQrcodeRemark() {
        return groupQrcodeRemark;
    }

    public void setGroupQrcodeRemark(String groupQrcodeRemark) {
        this.groupQrcodeRemark = groupQrcodeRemark;
    }

    @Override
    public String toString() {
        return "BookGroup{" +
                "id=" + id +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", sceneId=" + sceneId +
                ", groupQrcodeUrl='" + groupQrcodeUrl + '\'' +
                ", groupQrcodeName='" + groupQrcodeName + '\'' +
                ", proLabelId=" + proLabelId +
                ", depLabelId=" + depLabelId +
                ", purLabelId=" + purLabelId +
                ", joinTitle='" + joinTitle + '\'' +
                ", joinSlogan='" + joinSlogan + '\'' +
                ", personalQrcodeUrl='" + personalQrcodeUrl + '\'' +
                ", productId=" + productId +
                ", createUser=" + createUser +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", isDelete=" + isDelete +
                ", isShowBookName=" + isShowBookName +
                ", joinGroupType=" + joinGroupType +
                ", addFriendGuide='" + addFriendGuide + '\'' +
                ", customerServiceName='" + customerServiceName + '\'' +
                ", isInviteGroup=" + isInviteGroup +
                ", bookGroupCipher='" + bookGroupCipher + '\'' +
                ", lastPushUpdateTime=" + lastPushUpdateTime +
                ", isSomeUpdate=" + isSomeUpdate +
                ", agentId=" + agentId +
                ", belongSpecialAgent=" + belongSpecialAgent +
                ", shortBookName='" + shortBookName + '\'' +
                ", singleGroup=" + singleGroup +
                ", relatedBookGroupId=" + relatedBookGroupId +
                ", friendGuideList=" + friendGuideList +
                ", openWeapp=" + openWeapp +
                ", groupQrcodePageNum=" + groupQrcodePageNum +
                ", groupQrcodeLocationId=" + groupQrcodeLocationId +
                ", groupQrcodeRemark='" + groupQrcodeRemark + '\'' +
                ", groupQrcodeLink='" + groupQrcodeLink + '\'' +
                ", jumpType=" + jumpType +
                ", jumpUrl='" + jumpUrl + '\'' +
                '}';
    }
}