package com.pcloud.book.timesscreen.service.impl;

import com.google.common.collect.Lists;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.biz.BookAdviserBiz;
import com.pcloud.book.book.biz.BookBiz;
import com.pcloud.book.book.biz.BookTypeBiz;
import com.pcloud.book.book.dto.BookCountDto;
import com.pcloud.book.book.dto.BookTypeDto;
import com.pcloud.book.group.biz.BookGroupBiz;
import com.pcloud.book.timesscreen.service.TimesBookService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ResponseHandleUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import javax.annotation.Resource;

@RestController
@RequestMapping("timesBookService")
public class TimesBookServiceImpl implements TimesBookService {

    @Resource
    private BookAdviserBiz bookAdviserBiz;
    @Autowired
    private BookBiz bookBiz;
    @Autowired
    private BookGroupBiz bookGroupBiz;
    @Autowired
    private BookTypeBiz bookTypeBiz;

    @Override
    @PostMapping("getBookCount")
    public ResponseEntity<ResponseDto<Integer>> getBookCount(@RequestBody List<Long> agentIds) {
        return ResponseHandleUtil.toResponse(bookAdviserBiz.getBookCounts(agentIds));
    }

    @Override
    @PostMapping("listBookCountByDate4Agent")
    public ResponseEntity<ResponseDto<List<BookCountDto>>> listBookCountByDate4Agent(@RequestBody List<Long> agentIds) {
        return ResponseHandleUtil.toResponse(bookAdviserBiz.listBookCountByDate4Agents(agentIds));
    }

    @GetMapping("listPageIncomeDetail")
    @Override
    public ResponseEntity<ResponseDto<PageBeanNew>> listPageIncomeDetail(@RequestParam(value = "agentId") Long agentId,
                                                                         @RequestParam(value = "keyWord", required = false) String keyWord,
                                                                         @RequestParam(value = "channelId", required = false) Long channelId,
                                                                         @RequestParam(value = "typeCode", required = false) String typeCode,
                                                                         @RequestParam(value = "currentPage") Integer currentPage,
                                                                         @RequestParam(value = "numPerPage") Integer numPerPage,
                                                                         @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
                                                                         @RequestParam(value = "templetId", required = false) Long templetId,
                                                                         @RequestParam(value = "secondTempletId", required = false) Long secondTempletId) {
            if (currentPage == null || numPerPage == null || currentPage < 0 || numPerPage < 0) {
                throw BookBizException.PAGE_PARAM_DELETION;
            }
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("keyWord", keyWord != null && "".equals(keyWord.trim()) ? null : keyWord);
            paramMap.put("channelId", channelId);
            paramMap.put("typeCode", typeCode != null && "".equals(typeCode.trim()) ? null : typeCode);
            paramMap.put("isFundSupport", isFundSupport);
            paramMap.put("templetId", templetId);
            paramMap.put("secondTempletId", secondTempletId);
            paramMap.put("secondTempletIds", Optional.ofNullable(paramMap.get("secondTempletId")).map(Lists::newArrayList).orElse(Lists.newArrayList()));
            return ResponseHandleUtil.toResponse(bookBiz.listPageIncomeDetail4Times(new PageParam(currentPage, numPerPage), paramMap, agentId));
    }

    @Override
    @GetMapping("exportBookIncomeDetail")
    public ResponseEntity<ResponseDto<Map<String,Object>>> exportBookIncomeDetail(@RequestParam(value = "agentId") Long agentId,
                                                                           @RequestParam(value = "keyWord", required = false) String keyWord,
                                                                           @RequestParam(value = "channelId", required = false) Long channelId,
                                                                           @RequestParam(value = "typeCode", required = false) String typeCode,
                                                                           @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
                                                                           @RequestParam(value = "templetId", required = false) Long templetId,
                                                                           @RequestParam(value = "secondTempletId", required = false) Long secondTempletId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("keyWord", keyWord != null && "".equals(keyWord.trim()) ? null : keyWord);
        paramMap.put("channelId", channelId);
        paramMap.put("typeCode", typeCode != null && "".equals(typeCode.trim()) ? null : typeCode);
        paramMap.put("isFundSupport", isFundSupport);
        paramMap.put("templetId", templetId);
        paramMap.put("secondTempletId", secondTempletId);
        paramMap.put("secondTempletIds", Optional.ofNullable(paramMap.get("secondTempletId")).map(Lists::newArrayList).orElse(Lists.newArrayList()));
        return ResponseHandleUtil.toResponse(bookBiz.exportBookIncomeDetail4Times(paramMap, agentId));
    }

    @Override
    @PostMapping("getAddFriendCount4Times")
    public ResponseEntity<ResponseDto<Integer>> getAddFriendCount4Times(@RequestBody List<Long> agentIds) {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getAddFriendCount4Times(agentIds));
    }

    @Override
    @PostMapping("getWxUserInAgents")
    public ResponseEntity<ResponseDto<List<String>>> getWxUserInAgents(@RequestBody List<Long> agentIds) {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getWxUserInAgents(agentIds));
    }

    @Override
    @PostMapping("getBookGroupIdInAgents")
    public ResponseEntity<ResponseDto<List<Long>>> getBookGroupIdInAgents(@RequestBody List<Long> agentIds) {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getBookGroupIdInAgents(agentIds));
    }

    @Override
    @GetMapping("list")
    public ResponseEntity<ResponseDto<List<BookTypeDto>>> list() {
        List<BookTypeDto> bookTypeDtos = bookTypeBiz.getList();
        List<BookTypeDto> result = bookTypeDtos == null ? new ArrayList<>() : bookTypeDtos;
        return ResponseHandleUtil.toResponse(result);
    }

}
