package com.pcloud.book.book.constant;

import com.pcloud.common.constant.CacheConstant;

/**
 * 描述 :图书常量
 *
 * @author 作者: lili
 * @version 1.0
 * @date 创建时间：2017年7月18日 上午10:02:36
 */
public class BookConstant {

    /**
     * 图书基础缓存前缀名称
     */
    public static final String BOOK_CACHE = CacheConstant.BOOK + "BOOK:";

    /**
     * 图书缓存时间60分钟
     */
    public static final Integer BOOK_CACHE_SECOUND = 3600;

    /**
     * 图书基础缓存前缀名称
     */
    public static final String BOOK_ISBN_CACHE = CacheConstant.BOOK + "ISBN:";

    /**
     * 图书应用关联缓存前缀名称
     */
    public static final String BOOK_APP_CACHE = CacheConstant.BOOK + "BOOK_APP:";

    /**
     * 图书商品关联缓存前缀名称
     */
    public static final String BOOK_PRODUCT_CACHE = CacheConstant.BOOK + "BOOK_PRODUCT:";

    /**
     * 图书资源关联缓存前缀名称
     */
    public static final String BOOK_RESOURCE_CACHE = CacheConstant.BOOK + "BOOK_RESOURCE:";

    /**
     * 图书缓存时间1天
     */
    public static final Integer BOOK_CACHE_ONE_DAY = 60 * 60 * 24;

    /**
     * 图书缓存时间1月
     */
    public static final Integer BOOK_CACHE_ONE_MONTH = 60 * 60 * 24 * 30;

    /**
     * 图书编辑状态 1已删除
     */
    public static final Integer BOOK_ADVISER_DELETE = 1;

    /**
     * 图书编辑状态 0未删除
     */
    public static final Integer BOOK_ADVISER_NO_DELETE = 0;

    /**
     * 图书应用关系 1删除
     */
    public static final Integer BOOK_APP_DELETE = 1;

    /**
     * 图书应用关系 0未删除
     */
    public static final Integer BOOK_APP_NO_DELETE = 0;

    /**
     * 主編輯
     */
    public static final Integer MAIN_ADVISER = 1;

    /**
     * 副編輯
     */
    public static final Integer VICE_ADVISER = 0;

    /**
     * 默认图书isbn
     */
    public static final String DEFAULT_BOOK_ISBN = "9787507600000";

    /**
     * 图书查询个数
     */
    public static final Integer BOOK_SELECT_COUNT = 500;

    /**
     * 主编辑
     */
    public static final Integer MAIN_EDITOR = 1;

    /**
     * 副编辑
     */
    public static final Integer NOT_MAIN_EDITOR = 0;
}
