package com.pcloud.book.book.service;

import com.pcloud.book.book.dto.BookFundDto;
import com.pcloud.book.book.dto.BookFundInfoDto;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @描述：
 * @作者：lihao
 * @创建时间：2017年7月21日,下午5:27:09 @版本：1.0
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookFundServiceCloud", path = "book/v1.0/bookFundService")
@Api(description = "编辑推广书籍内部服务")
public interface BookFundService {

    /**
     * @param bookId
     * @param date
     * @throws BizException
     * @Title: isFundOccupy
     * @Description:判断书刊某时间是否被买断
     * @return: Boolean
     * @author: lihao
     * @date: 2017年7月21日 上午9:04:34
     */
    @ApiOperation(value = "判断书刊某时间是否被买断", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "date", value = "时间", dataType = "String", paramType = "query")})
    @RequestMapping(value = "/isFundOccupy", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<Boolean>> isFundOccupy(@RequestParam(value = "bookId", required = false) Long bookId,
                                                      @RequestParam(value = "date", required = false) String date) throws BizException;

    /**
     * @param bookIds
     * @throws BizException
     * @Title: getBookFundMoney
     * @Description:批量获取书刊基金总额
     * @return: Map<Long,BigDecimal>
     * @author: lihao
     * @date: 2017年7月21日 上午10:25:54
     */
    @ApiOperation(value = "批量获取书刊基金总额", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookIds", value = "图书id集合", dataType = "List<Long>", paramType = "body")})
    @RequestMapping(value = "/getBookFundMoney", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<Long, BigDecimal>>> getBookFundMoney(
            @RequestBody(required = false) List<Long> bookIds) throws BizException;

    /**
     * 获取图书在基金支持的基金名称
     *
     * @param bookId
     * @param useDate
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "获取图书在基金支持的基金名称", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "图书id", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "useDate", value = "当前时间", dataType = "String", paramType = "query")})
    @RequestMapping(value = "/getUseFundName", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<String>> getUseFundName(@RequestParam(value = "bookId", required = false) Long bookId,
                                                       @RequestParam(value = "useDate", required = false) String useDate) throws BizException;


    /**
     * 获取图书下的所有基金信息
     *
     * @param bookId
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "获取图书下的所有基金信息", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "图书id", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/getByBookId", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<List<BookFundDto>>> getByBookId(
            @RequestParam(value = "bookId", required = false) Long bookId) throws BizException;

    /**
     * 正在基金支持的图书
     *
     * @param bookIds
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "正在基金支持的图书", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookIds", value = "图书id集合", dataType = "List<Long>", paramType = "body")})
    @RequestMapping(value = "/getHaveFundBook", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Long>> getHaveFundBook(@RequestBody(required = true) List<Long> bookIds)
            throws BizException;

    /**
     * 正在基金支持的图书列表
     * @param bookIds 图书标识
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "正在基金支持的图书列表", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookIds", value = "图书id集合", dataType = "List<Long>", paramType = "body")})
    @RequestMapping(value = "/listHaveFundBooks", method = RequestMethod.POST)
	ResponseEntity<ResponseDto<List<Long>>> listHaveFundBooks(@RequestBody(required = false) List<Long> bookIds) throws BizException;
    
    /**
     * 获取所有正在基金支持的书
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "获取所有正在基金支持的书", httpMethod = "GET")
    @RequestMapping(value = "/listAllHaveFundBooks", method = RequestMethod.GET)
	ResponseEntity<ResponseDto<List<Long>>> listAllHaveFundBooks() throws BizException;

    @ApiOperation(value = "获取图书在基金支持的基金信息",httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "图书id", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "useDate", value = "当前时间", dataType = "String", paramType = "query")})
    @RequestMapping(value = "/getUseFundInfo", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookFundInfoDto>> getUseFundInfo(@RequestParam(value = "bookId", required = false) Long bookId,
                                                                @RequestParam(value = "useDate", required = false) String useDate) throws BizException;
}
