package com.pcloud.book;

import com.alibaba.druid.pool.DruidDataSource;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.common.core.constant.MQTopicProducer;
import com.pcloud.common.core.mq.RabbitMQFactory;
import feign.Request;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import javax.sql.DataSource;
import java.util.ArrayList;

@SpringBootApplication
@EnableAutoConfiguration
@ComponentScan("com.pcloud")
@EnableEurekaClient
@EnableFeignClients("com.pcloud")
@PropertySources(@PropertySource(value = "classpath:properties/book.properties"))
@Configuration
@EnableSwagger2
public class BookApplication {

    public static void main(String[] args) {
        SpringApplication.run(BookApplication.class, args);
    }

    @Bean
    public Docket createRestApi() {// 创建API基本信息
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.pcloud"))// 扫描该包下的所有需要在Swagger中展示的API，@ApiIgnore注解标注的除外
                .paths(PathSelectors.any())
                .build();
    }

    @SuppressWarnings("deprecation")
	private ApiInfo apiInfo() {// 创建API的基本信息，这些信息会在Swagger UI中进行显示
        return new ApiInfoBuilder()
                .title("图书，融合版")// API 标题
                .description("图书，融合了spring-cloud & dubbo的接口")// API描述
                .contact("李莉")// 联系人
                .version("2.0.0")// 版本号
                .build();
    }

    @Bean
    public DataSource setDataSourceProperties(@Autowired DataSource dataSource) {
        ArrayList<String> arr = new ArrayList<>();
        arr.add("set names utf8mb4;");
        ((DruidDataSource) dataSource).setConnectionInitSqls(arr);
        return dataSource;
    }
    @Bean
    public ActiveMQConnectionFactory activeMQConnectionFactory(@Value("${mq.brokerURL}") String url) {
        ActiveMQConnectionFactory	activeMQConnectionFactory = new ActiveMQConnectionFactory();
        activeMQConnectionFactory.setBrokerURL(url);
        activeMQConnectionFactory.setTrustAllPackages(true);
        return activeMQConnectionFactory;
    }
	
	
    @Bean
    public Queue chooseDefaultChannelQueue(){
        return RabbitMQFactory.queueBuilder(MQTopicConumer.CHOOSE_DEFAULT_CHANNEL);
    }

    @Bean
    public Binding chooseDefaultChannelBind(){
        return RabbitMQFactory.bindingExchange(chooseDefaultChannelQueue(), MQTopicProducer.CHOOSE_DEFAULT_CHANNEL);
    }

    //调用超时设置
    @Bean
    Request.Options feignOptions() {
        return new Request.Options(300 * 1000, 300 * 1000);
    }
}
