/**
 * 
 */
package com.pcloud.book.book.facade.impl;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.pcloud.book.base.dto.CountDto;
import com.pcloud.book.book.biz.BookAppBiz;
import com.pcloud.book.book.dto.BookAppDto;
import com.pcloud.book.book.entity.BookApp;
import com.pcloud.book.book.facade.BookAppFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

/**
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2016年12月23日,下午4:08:08 @版本：1.0
 */
@RequestMapping("/bookApp")
@RestController("bookAppFacade")
@Produces({ ContentType.APPLICATION_JSON_UTF_8 })
@Consumes({ MediaType.APPLICATION_JSON })
public class BookAppFacadeImpl implements BookAppFacade {

	@Autowired
	private BookAppBiz bookAppBiz;

	/**
	 * 添加书籍和应用关联关系
	 */
	@Override
	@RequestMapping(value = "create", method = RequestMethod.POST)
	public ResponseDto<BookAppDto> create(@RequestHeader("token") String token, @RequestBody BookApp bookApp)
			throws BizException, PermissionException, JsonParseException {
		// token
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookApp.setCreatedUser(adviserId);
		// 添加
		bookAppBiz.create(bookApp);

		BookAppDto bookAppDto = new BookAppDto();
		bookAppDto.setBookAppId(bookApp.getBookAppId());
		return new ResponseDto<>(bookAppDto);
	}

	/**
	 * 微信端添加书籍和应用关联关系
	 */
	@Override
	@RequestMapping(value = "create4Wechat", method = RequestMethod.POST)
	public ResponseDto<BookAppDto> create4Wechat(@CookieValue("userInfo") String userInfo, @RequestBody BookApp bookApp)
			throws BizException, PermissionException, JsonParseException {
		// token
		Long adviserId = Cookie.getId(userInfo, Cookie._PARTY_ID);
		bookApp.setCreatedUser(adviserId);
		// 添加
		bookAppBiz.create(bookApp);

		BookAppDto bookAppDto = new BookAppDto();
		bookAppDto.setBookAppId(bookApp.getBookAppId());
		return new ResponseDto<>(bookAppDto);
	}

	/**
	 * 删除书籍应用关联关系
	 */
	@Override
	@RequestMapping(value = "delete", method = RequestMethod.GET)
	public ResponseDto<?> delete(@RequestHeader("token") String token,
			@RequestParam(value = "bookAppId", required = false) Long bookAppId)
			throws BizException, PermissionException, JsonParseException {
		// token
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookAppBiz.delete(bookAppId);
		return new ResponseDto<>();
	}

	/**
	 * 微信端删除书籍应用关联关系
	 */
	@Override
	@RequestMapping(value = "delete4Wechat", method = RequestMethod.GET)
	public ResponseDto<?> delete4Wechat(@CookieValue("userInfo") String userInfo,
			@RequestParam(value = "bookAppId", required = false) Long bookAppId)
			throws BizException, PermissionException, JsonParseException {
		// Cookie
		Cookie.getId(userInfo, Cookie._PARTY_ID);
		bookAppBiz.delete(bookAppId);
		return new ResponseDto<>();
	}

	/**
	 * 获取书籍关联的应用
	 */
	@Override
	@RequestMapping(value = "listById", method = RequestMethod.GET)
	public ResponseDto<List<BookAppDto>> getListById(@CookieValue("userInfo") String userInfo,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "adviserId", required = false) Long adviserId)
			throws BizException, PermissionException, JsonParseException {
		// token
		Long channelId = Cookie.getId(userInfo, Cookie._CHANNEL_ID);
		List<BookAppDto> bookAppDtos = bookAppBiz.getListById(bookId, adviserId, channelId);
		return new ResponseDto<>(bookAppDtos == null ? new ArrayList<>() : bookAppDtos);
	}

	/**
	 * 获取书籍关联的应用
	 */
	@Override
	@RequestMapping(value = "listById4Adviser", method = RequestMethod.GET)
	public ResponseDto<List<BookAppDto>> getListById4Adviser(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException {
		// 获取书籍关联应用
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		List<BookAppDto> bookAppDtos = bookAppBiz.getListById4Adviser(bookId, adviserId, channelId);
		return new ResponseDto<List<BookAppDto>>(bookAppDtos == null ? new ArrayList<>() : bookAppDtos);
	}

	/**
	 * 获取图书关联应用个数
	 */
	@Override
	@RequestMapping(value = "getAppCount", method = RequestMethod.GET)
	public ResponseDto<CountDto> getAppCount(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException {
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		Integer count = bookAppBiz.getAppCount(adviserId, bookId, channelId);
		CountDto countDto = new CountDto();
		countDto.setCount(count);
		return new ResponseDto<>(countDto);
	}

	/**
	 * 获取书籍关联的应用-出版端
	 */
	@Override
	@RequestMapping(value = "listById4Agent", method = RequestMethod.GET)
	public ResponseDto<List<BookAppDto>> getListById4Agent(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId,
			@RequestParam(value = "adviserId", required = false) Long adviserId)
			throws BizException, PermissionException, JsonParseException {
		// 获取书籍关联应用
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		List<BookAppDto> bookAppDtos = bookAppBiz.getListById4Adviser(bookId, adviserId, channelId);
		return new ResponseDto<List<BookAppDto>>(bookAppDtos == null ? new ArrayList<>() : bookAppDtos);
	}

}
