/**
 * 
 */
package com.pcloud.book.book.facade.impl;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.pcloud.book.base.dto.CountDto;
import com.pcloud.book.book.biz.BookProductBiz;
import com.pcloud.book.book.dto.BookProductDto;
import com.pcloud.book.book.entity.BookProduct;
import com.pcloud.book.book.facade.BookProductFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

/**
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2016年12月23日,下午4:08:08 @版本：1.0
 */
@RequestMapping("/bookProduct")
@RestController("bookProductFacade")
@Produces({ ContentType.APPLICATION_JSON_UTF_8 })
@Consumes({ MediaType.APPLICATION_JSON })
public class BookProductFacadeImpl implements BookProductFacade {

	@Autowired
	private BookProductBiz bookProductBiz;

	/**
	 * 添加书籍和应用关联关系
	 */
	@Override
	@RequestMapping(value = "create", method = RequestMethod.POST)
	public ResponseDto<BookProductDto> create(@RequestHeader("token") String token,
			@RequestBody BookProduct bookProduct) throws BizException, PermissionException, JsonParseException {
		// token
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookProduct.setCreatedUser(adviserId);
		// 添加
		bookProductBiz.create(bookProduct);

		BookProductDto bookProductDto = new BookProductDto();
		bookProductDto.setBookProductId(bookProduct.getBookProductId());
		return new ResponseDto<>(bookProductDto);
	}

	/**
	 * 微信端添加书籍和应用关联关系
	 */
	@Override
	@RequestMapping(value = "create4Wechat", method = RequestMethod.POST)
	public ResponseDto<BookProductDto> create4Wechat(@CookieValue("userInfo") String userInfo,
			@RequestBody BookProduct bookProduct) throws BizException, PermissionException, JsonParseException {
		// Cookie
		Long adviserId = Cookie.getId(userInfo, Cookie._PARTY_ID);
		bookProduct.setCreatedUser(adviserId);
		// 添加
		bookProductBiz.create(bookProduct);

		BookProductDto bookProductDto = new BookProductDto();
		bookProductDto.setBookProductId(bookProduct.getBookProductId());
		return new ResponseDto<>(bookProductDto);
	}

	/**
	 * 删除书籍应用关联关系
	 */
	@Override
	@RequestMapping(value = "delete", method = RequestMethod.GET)
	public ResponseDto<?> delete(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "productId", required = false) Long productId,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException {
		// token
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookProductBiz.delete(bookId, productId, adviserId, channelId);
		return new ResponseDto<>();
	}

	/**
	 * 微信端删除书籍应用关联关系
	 */
	@Override
	@RequestMapping(value = "delete4Wechat", method = RequestMethod.GET)
	public ResponseDto<?> delete4Wechat(@CookieValue("userInfo") String userInfo,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "productId", required = false) Long productId,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException {
		// token
		Long adviserId = Cookie.getId(userInfo, Cookie._PARTY_ID);
		bookProductBiz.delete(bookId, productId, adviserId, channelId);
		return new ResponseDto<>();
	}

	/**
	 * 获取书籍关联的作品
	 */
	@Override
	@RequestMapping(value = "listById", method = RequestMethod.GET)
	public ResponseDto<List<BookProductDto>> getListById(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException {
		// token
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		return new ResponseDto<>(bookProductBiz.getListById(bookId, adviserId, channelId));
	}

	/**
	 * 设置录音
	 */
	@Override
	@RequestMapping(value = "setSound", method = RequestMethod.POST)
	public ResponseDto<?> setSound(@RequestHeader("token") String token, @RequestBody BookProduct bookProduct)
			throws BizException, PermissionException, JsonParseException {
		// token
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookProductBiz.setSound(bookProduct, adviserId);
		return new ResponseDto<>();
	}

	/**
	 * 微信端设置录音
	 */
	@Override
	@RequestMapping(value = "setSound4Wechat", method = RequestMethod.POST)
	public ResponseDto<?> setSound4Wechat(@CookieValue("userInfo") String userInfo,
			@RequestBody BookProduct bookProduct) throws BizException, PermissionException, JsonParseException {
		// Cookie
		Long adviserId = Cookie.getId(userInfo, Cookie._PARTY_ID);
		bookProductBiz.setSound(bookProduct, adviserId);
		return new ResponseDto<>();
	}

	/**
	 * 更新商品类型
	 */
	@Override
	@RequestMapping(value = "updateProductType", method = RequestMethod.GET)
	public ResponseDto<?> updateProductType() throws BizException, PermissionException, JsonParseException {
		bookProductBiz.updateProductType();
		return new ResponseDto<>();
	}

	/**
	 * 获取书籍关联作品（pc-编辑）
	 */
	@Override
	@RequestMapping(value = "list4Adviser", method = RequestMethod.GET)
	public ResponseDto<List<BookProductDto>> list4Adviser(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException {
		// token
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		List<BookProductDto> bookProductDtos = bookProductBiz.list4Adviser(bookId, channelId, adviserId);
		return new ResponseDto<List<BookProductDto>>(
				bookProductDtos == null ? new ArrayList<BookProductDto>() : bookProductDtos);
	}

	/**
	 * 获取图书关联超级作者商品个数
	 */
	@Override
	@RequestMapping(value = "getSuperProCount", method = RequestMethod.GET)
	public ResponseDto<CountDto> getSuperProCount(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException {
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		Integer count = bookProductBiz.getSuperProCount(adviserId, bookId, channelId);
		CountDto countDto = new CountDto();
		countDto.setCount(count);
		return new ResponseDto<>(countDto);
	}

	/**
	 * 获取图书关联作品个数
	 */
	@Override
	@RequestMapping(value = "getProCount", method = RequestMethod.GET)
	public ResponseDto<CountDto> getProCount(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException {
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		Integer count = bookProductBiz.getProCount(adviserId, bookId, channelId);
		CountDto countDto = new CountDto();
		countDto.setCount(count);
		return new ResponseDto<>(countDto);
	}

	/**
	 * 获取书籍关联作品-出版端
	 */
	@Override
	@RequestMapping(value = "list4Agent", method = RequestMethod.GET)
	public ResponseDto<List<BookProductDto>> list4Agent(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "adviserId", required = false) Long adviserId,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException {
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		List<BookProductDto> bookProductDtos = bookProductBiz.list4Adviser(bookId, channelId, adviserId);
		return new ResponseDto<List<BookProductDto>>(bookProductDtos == null ? new ArrayList<>() : bookProductDtos);
	}
}
