/**
 * 
 */
package com.pcloud.book.book.tools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述：
 * @作者：songx
 * @创建时间：2017年5月5日,下午4:22:04
 * @版本：1.0
 */
public class BookTools {

	/**
	 * 组装运营标识(去重)
	 */
	public static List<Long> listChannelIds(List<Object> objects) throws BizException {
		Map<Long, Long> channelIdMap = new HashMap<>();
		for (Object object : objects) {
			BookDto bookDto = (BookDto) object;
			Long channelId = bookDto.getChannelId();
			if (!channelIdMap.containsKey(channelId)) {
				channelIdMap.put(channelId, channelId);
			}
		}
		return Lists.newArrayList(channelIdMap.values());
	}
	
	/**
	 * 组装图书标识(去重)
	 */
	public static List<Long> listBookIds(List<Object> objects) throws BizException {
		Map<Long, Long> bookIdMap = new HashMap<>();
		for (Object object : objects) {
			BookDto bookDto = (BookDto) object;
			Long bookId = bookDto.getBookId();
			if (!bookIdMap.containsKey(bookId)) {
				bookIdMap.put(bookId, bookId);
			}
		}
		return Lists.newArrayList(bookIdMap.values());
	}
	
	/**
	 * 批量填充运营信息
	 */
	public static void setChannelNames(List<Object> objects, Map<Long, String> channelNameMap) throws BizException {
		for (Object object : objects) {
			BookDto bookDto = (BookDto) object;
			Long channelId = bookDto.getChannelId();
			if (channelNameMap.containsKey(channelId)) {
				bookDto.setChannelName(channelNameMap.get(channelId));
			} else {
				bookDto.setChannelName("");
			}
		}
	}

	/**
	 * 组装编辑标识(去重)
	 * @param objects
	 * @return
	 */
	public static List<Long> listAdviserIds(List<Object> objects) {
		Map<Long, Long> adviserIdMap = new HashMap<>();
		for (Object object : objects) {
			BookDto bookDto = (BookDto) object;
			Long adviserId = bookDto.getAdviserId();
			if (!adviserIdMap.containsKey(adviserId)) {
				adviserIdMap.put(adviserId, adviserId);
			}
		}
		return Lists.newArrayList(adviserIdMap.values());
	}

	/**
	 * 批量填充编辑名称
	 * @param objects
	 * @param adviserNameMap
	 */
	public static void setAdviserNames(List<Object> objects, Map<Long, String> adviserNameMap) {
		for (Object object : objects) {
			BookDto bookDto = (BookDto) object;
			Long adviserId = bookDto.getAdviserId();
			if (adviserNameMap.containsKey(adviserId)) {
				bookDto.setAdviserName(adviserNameMap.get(adviserId));
			} else {
				bookDto.setAdviserName("");
			}
		}
	}
	
}
