/**
 * 
 */
package com.pcloud.book.consumer.message;

import java.util.Date;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.appcenter.base.exception.AppBizException;
import com.pcloud.common.core.biz.MessageBiz;
import com.pcloud.common.core.dto.SendMessageDto;
import com.pcloud.common.core.dto.SendNotifyDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.string.StringUtil;

/**
 * @描述：消息中心中间件
 * @作者：songx
 * @创建时间：2016年11月23日,下午5:08:44
 * @版本：1.0
 */
@Component("messageConsr")
public class MessageConsr {

	/**
	 * 
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(MessageConsr.class);
	
	@Autowired
	private MessageBiz messageBiz;
	/**
	 * 发送站内信
	 */
	public void sendLetter(Long fromId, Long toId, String content, String sysCode, String typeCode, String resourceId, String fileName)
			throws BizException {
		LOGGER.info("【站内信-消息(消)】发送站内信,<START>.[fromId]=" + fromId + ",[toId]=" + toId + ",[content]=" + content
				+ ",[sysCode]=" + sysCode + ",[typeCode]=" + typeCode + ",[resourceId]=" + resourceId+"[fileName]="+fileName);
		if (fromId == null || toId == null || StringUtil.isEmpty(content) || StringUtil.isEmpty(sysCode)
				|| StringUtil.isEmpty(typeCode) || resourceId == null) {
			return;
		}
		// 组装参数
		SendNotifyDto sendNotifyDto = new SendNotifyDto();
		sendNotifyDto.setCreatedTime(new Date());
		sendNotifyDto.setFromId(fromId);
		sendNotifyDto.setToId(toId);
		sendNotifyDto.setNotifyContent(content);
		sendNotifyDto.setSystemCode(sysCode);
		sendNotifyDto.setTypeCode(typeCode);
		sendNotifyDto.setResourceId(resourceId);
		sendNotifyDto.setFileName(fileName);
		try {
			messageBiz.sendLetter(sendNotifyDto);
		} catch (Exception e) {
			LOGGER.error("【站内信(消)】发送站内信.[sendLetter]:" + e.getMessage(), e);
		}
		LOGGER.info("【站内信(消)】发送站内信,<END>");
	}
	
	/**
	 * 发送手机消息
	 */
	public void sendSMS(String phone,Map<String, String> paramMap, String templateCode) throws BizException {
		LOGGER.info("【短信消息(消)】发送手机消息.<START>.[phone]=" + phone);
		if (StringUtil.isEmpty(phone)) {
			throw new AppBizException(AppBizException.PARAM_IS_NULL, "手机消息参数为空");
		}
		// 组装参数
		SendMessageDto smsParam = new SendMessageDto();
		smsParam.setSmsTemplateCode(templateCode);
		smsParam.setParamKeyMap(paramMap);
		smsParam.setPhoneNumber(phone);
		try {
			messageBiz.sendSMS(smsParam);
		} catch (Exception e) {
			LOGGER.error("【短信消息(消)】发送手机消息.[sendSMS]:" + e.getMessage(), e);
			throw new AppBizException(AppBizException.INVOKE_MESSAGE_ERROR, "发送手机消息失败");
		}
		
		LOGGER.info("【短信消息(消)】发送手机消息.<END>");
	}
	
}
