/**
 * 
 */
package com.pcloud.book.mq.topic;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.biz.BookProductBiz;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2017年7月5日,上午11:58:44 @版本：1.0
 */
@Component("deleteVideoListener")
public class DeleteVideoListener implements MessageListener {

	/**
	 * 
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(DeleteVideoListener.class);

	@Autowired
	private BookProductBiz bookProductBiz;

	/**
	 * 接收录音删除消息
	 */
	@Override
	public void onMessage(Message message) throws BizException {
		if (!(message instanceof ObjectMessage)) {
			throw new BookBizException(BookBizException.CONSUMER_TOPIC_ERROR, "【录音删除】类型转换错误");
		}
		try {
			// 转换消息实体
			ObjectMessage om = (ObjectMessage) message;
			Long videoId = Long.parseLong(om.getObject().toString());
			// 清除录音
			bookProductBiz.clearSound(videoId);
		} catch (Exception e) {
			LOGGER.error("【录音删除】消费topic,JMS异常,<ERROR>:" + e.getMessage(), e);
			return;
		}

	}
}
