package com.pcloud.book.mq.topic;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;

import com.pcloud.usercenter.common.enums.ResourceEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.appcenter.base.exception.AppBizException;
import com.pcloud.book.book.biz.BookAdviserBiz;
import com.pcloud.common.core.constant.SystemCode;
import com.pcloud.usercenter.party.common.entity.Party;

@Component("registerPartyListener")
public class RegisterPartyListener implements MessageListener {
	@Autowired
	private BookAdviserBiz bookAdviserBiz;
	private static final Logger LOGGER = LoggerFactory.getLogger(RegisterPartyListener.class);

	/**
	 * 用户注册Topic
	 */
	@Override
	public void onMessage(Message message) {
		if (!(message instanceof ObjectMessage)) {
			throw new AppBizException(AppBizException.CONSUMER_TOPIC_ERROR, "【注册用户】类型转换错误");
		}
		// 转换消息实体
		Party party = null;
		try {
			ObjectMessage om = (ObjectMessage) message;
			party = (Party) om.getObject();
		} catch (Exception e) {
			LOGGER.error("【注册用户】消费topic,<ERROR>:" + e.getMessage(), e);
			return;
		}
		if (party == null) {
			return;
		}
		if (SystemCode.adviser.code.equalsIgnoreCase(party.getPartyRole()) && ResourceEnum.APP.code.equals(party.getResourceId())) {
			bookAdviserBiz.createDefaultBook(party.getAgentId(), party.getId());
		}

	}
}
