/**
 * 
 */
package com.pcloud.book.util.properties;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @描述：微信常量类
 * @作者：songx
 * @创建时间：2016年11月23日,上午10:12:37 @版本：1.0
 */
@Component("bookProps")
public class BookProps {

	/**
	 * ISBN
	 */
	private static String appkey;

	/**
	 * 图书封面图
	 */
	private static String bookCoverImg;

	/**
	 * ISBN
	 */
	private static String appCode;

	/**
	 * ISBNjisuAppKey
	 */
	private static String jisuAppKey;

	/**
	 * 书籍删除
	 */
	private static String bookDeleteProducer;

	/**
	 * 录音删除
	 */
	private static String deleteVideoConsumer;

	/**
	 * 用户注册
	 */
	private static String registerPartyConsumer;
	
	/**
	 * 默认运营选择
	 */
	private static String chooseDefaultChannelConsumer;

	/**
	 * 图书解冻
	 */
	private static String bookThawProducer;

    public static String getBookThawProducer() {
        return bookThawProducer;
    }
    @Value("${book.thaw.producer}")
    public void setBookThawProducer(String bookThawProducer) {
        BookProps.bookThawProducer = bookThawProducer;
    }

    public static String getBookDeleteProducer() {
		return bookDeleteProducer;
	}

	@Value("${book.delete.producer}")
	public void setBookDeleteProducer(String bookDeleteProducer) {
		BookProps.bookDeleteProducer = bookDeleteProducer;
	}

	public static String getJisuAppKey() {
		return jisuAppKey;
	}

	@Value("${isbn.jisu.appkey}")
	public void setJisuAppKey(String jisuAppKey) {
		BookProps.jisuAppKey = jisuAppKey;
	}

	public static String getAppkey() {
		return appkey;
	}

	public static String getBookCoverImg() {
		return bookCoverImg;
	}

	public static String getAppCode() {
		return appCode;
	}

	@Value("${isbn.appkey}")
	public void setAppkey(String appkey) {
		BookProps.appkey = appkey;
	}

	@Value("${book.cover.img}")
	public void setBookCoverImg(String bookCoverImg) {
		BookProps.bookCoverImg = bookCoverImg;
	}

	@Value("${isbn.appCode}")
	public void setAppCode(String appCode) {
		BookProps.appCode = appCode;
	}

	public static String getDeleteVideoConsumer() {
		return deleteVideoConsumer;
	}

	@Value("${delete.video.consumer}")
	public void setDeleteVideoConsumer(String deleteVideoConsumer) {
		BookProps.deleteVideoConsumer = deleteVideoConsumer;
	}

	@Value("${register.party.consumer}")
	public  void setRegisterPartyConsumer(String registerPartyConsumer) {
		BookProps.registerPartyConsumer = registerPartyConsumer;
	}

	public static String getRegisterPartyConsumer() {
		return registerPartyConsumer;
	}
	public static String getChooseDefaultChannelConsumer() {
		return chooseDefaultChannelConsumer;
	}
	@Value("${choose.default.channel.consumer}")
	public  void setChooseDefaultChannelConsumer(String chooseDefaultChannelConsumer) {
		BookProps.chooseDefaultChannelConsumer = chooseDefaultChannelConsumer;
	}

}
