package com.pcloud.book.custom.biz;

import com.pcloud.book.custom.entity.CustomPlan;
import com.pcloud.book.custom.vo.CustomPlanModuleVO;
import com.pcloud.book.custom.vo.CustomPlanPaperVO;
import com.pcloud.book.custom.vo.EditCustomPlanModuleVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

public interface CustomPlanBiz {

    Integer createCustomPlan(CustomPlan customPlan);

    void copyCustomPlan(Integer planId);

    void updateCustomPlan(CustomPlan customPlan);

    CustomPlan getCustomPlanById(Integer planId);

    void deleteCustomPlanById(Integer planId);

    PageBeanNew<CustomPlan> listCustomPlanByPage(Integer currentPage, Integer numPerPage, String content, Integer useState);

    void editCustomPlanModule(EditCustomPlanModuleVO editCustomPlanModuleVO);

    List<CustomPlanModuleVO> getCustomPlanModule(Integer planId);

    PageBeanNew<CustomPlanPaperVO> listPlanPaperByPage(Integer currentPage, Integer numPerPage, Integer paperState, String content);

    Map<String, Object> getShortLinkUrl(Long appId, Long productId, String linkUrl);
}
