package com.pcloud.book.custom.biz.impl;

import com.google.common.collect.Lists;
import com.pcloud.book.custom.biz.CustomPlanBiz;
import com.pcloud.book.custom.dto.CustomPlanEmailDto;
import com.pcloud.book.custom.entity.CustomPlan;
import com.pcloud.book.custom.entity.CustomPlanEmail;
import com.pcloud.book.custom.dao.CustomPlanEmailDao;
import com.pcloud.book.custom.biz.CustomPlanEmailBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.biz.MessageBiz;
import com.pcloud.common.core.dto.SendEmailDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.DateNewUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.common.utils.string.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 邮件提醒(CustomPlanEmail)表服务实现类
 *
 * @author zyq
 * @since 2020-03-06 13:04:25
 */
@Service("customPlanEmailBiz")
public class CustomPlanEmailBizImpl implements CustomPlanEmailBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(CustomPlanEmailBizImpl.class);

    @Autowired
    private CustomPlanEmailDao customPlanEmailDao;
    @Autowired
    private CustomPlanBiz customPlanBiz;
    @Autowired
    private MessageBiz messageBiz;

    @Override
    @ParamLog("通过ID查询单条数据")
    public CustomPlanEmailDto getCustomPlanEmailByPlanId(Integer customPlanId) {
        CustomPlanEmailDto customPlanEmailDto = new CustomPlanEmailDto();
        customPlanEmailDto.setEmailList(Lists.newArrayList());
        CustomPlanEmail customPlanEmail = customPlanEmailDao.getCustomPlanEmailByPlanId(customPlanId);
        if(customPlanEmail == null){
            return customPlanEmailDto;
        }
        BeanUtils.copyProperties(customPlanEmail, customPlanEmailDto);
        customPlanEmailDto.setEmailList(Lists.newArrayList(customPlanEmail.getEmails().split(";")));
        return customPlanEmailDto;
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = customPlanEmailDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)){
            return pageBeanNew;
        }
        // 加载其它数据
        
        return pageBeanNew;
    }

    @Override
    @ParamLog("发送邮件提醒")
    public Long sendCustomPlanEmail(CustomPlanEmailDto customPlanEmailDto) {
        if( !NumberUtil.isNumber(customPlanEmailDto.getCustomPlanId()) && customPlanEmailDto.getCustomPlanId() > 0){
            throw new BizException(BizException.DB_SELECTONE_IS_NULL.getCode(),"panId不能为空");
        }
        if(customPlanEmailDto.getEmailList() == null || customPlanEmailDto.getEmailList().size() <= 0
                || customPlanEmailDto.getEmailList().stream().filter(x-> StringUtil.isNotEmpty(x)).count() == 0){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(),"请填写邮箱");
        }
        CustomPlan customPlan = customPlanBiz.getCustomPlanById(customPlanEmailDto.getCustomPlanId());
        if(customPlan == null){
            throw new BizException(BizException.DB_SELECTONE_IS_NULL.getCode(),"方案不存在，无法发送邮件");
        }
        CustomPlanEmail customPlanEmail = new CustomPlanEmail();
        BeanUtils.copyProperties(customPlanEmailDto, customPlanEmail);
        customPlanEmail.setEmails(String.join(";",customPlanEmailDto.getEmailList()));
        customPlanEmailDao.insert(customPlanEmail);
        customPlanEmailDto.setId(customPlanEmail.getId());
        sendEmail(customPlanEmailDto, customPlan);
        return customPlanEmail.getId();
    }

    @ParamLog("发送方案邮件提醒")
    private void sendEmail(CustomPlanEmailDto customPlanEmailDto, CustomPlan customPlan) {
        try {
            SendEmailDto sendEmailDto = new SendEmailDto();
            sendEmailDto.setTypeCode("custom_plan_email_remind");
            Map<String, Object> content = new HashMap<>();
            content.put("planNumber", customPlan.getPlanNumber());
            content.put("planName", customPlan.getPlanName());
            content.put("createUserName", customPlan.getCreateUserName());
            content.put("planDescription", customPlan.getDescription());
            content.put("planH5Url", customPlan.getH5Url());
            content.put("robotClassifyName", customPlanEmailDto.getPcloudRobotClassifyName());
            content.put("robotId", customPlanEmailDto.getRobotId());
            content.put("userWxId", customPlanEmailDto.getUserWxId());
            content.put("description", customPlanEmailDto.getDescription());
            sendEmailDto.setContent(content);
            for(String email : customPlanEmailDto.getEmailList()){
                sendEmailDto.setToEmail(email);
                messageBiz.sendEmail(sendEmailDto);
            }
        } catch (Exception e) {
            LOGGER.error("发送方案邮件提醒出错：" + e.getMessage(), e);
        }
    }
}