package com.pcloud.book.custom.facade;

import com.pcloud.book.custom.biz.CustomPlanBiz;
import com.pcloud.book.custom.biz.CustomPlanEmailBiz;
import com.pcloud.book.custom.dto.CustomPlanEmailDto;
import com.pcloud.book.custom.entity.CustomPlan;
import com.pcloud.book.custom.vo.CustomPlanModuleVO;
import com.pcloud.book.custom.vo.EditCustomPlanModuleVO;
import com.pcloud.book.timecontrol.vo.CreateSelfPlanVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RequestMapping("customPlan")
@RestController("customPlanFacade")
public class CustomPlanFacade {

    @Autowired
    private CustomPlanBiz customPlanBiz;
    @Autowired
    private CustomPlanEmailBiz customPlanEmailBiz;

    @ApiOperation("创建定制方案")
    @PostMapping("createCustomPlan")
    ResponseDto<?> createCustomPlan(@RequestHeader String token, @RequestBody CustomPlan customPlan) {
        return new ResponseDto<>(customPlanBiz.createCustomPlan(customPlan));
    }

    @ApiOperation("复制定制方案")
    @GetMapping("copyCustomPlan")
    ResponseDto<?> copyCustomPlan(@RequestHeader String token, @RequestParam Integer planId) {
        customPlanBiz.copyCustomPlan(planId);
        return new ResponseDto<>();
    }

    @ApiOperation("修改定制方案")
    @PostMapping("updateCustomPlan")
    ResponseDto<?> updateCustomPlan(@RequestHeader String token, @RequestBody CustomPlan customPlan) {
        customPlanBiz.updateCustomPlan(customPlan);
        return new ResponseDto<>();
    }

    @ApiOperation("根据ID获取定制方案(平台端)")
    @GetMapping("getCustomPlanById")
    ResponseDto<?> getCustomPlanById(@RequestHeader String token, @RequestParam Integer planId) {
        return new ResponseDto<>(customPlanBiz.getCustomPlanById(planId));
    }

    @ApiOperation("根据ID获取定制方案(微信端)")
    @GetMapping("getCustomPlanById4Wechat")
    ResponseDto<?> getCustomPlanById4Wechat(@RequestParam Integer planId) {
        return new ResponseDto<>(customPlanBiz.getCustomPlanById(planId));
    }

    @ApiOperation("根据ID删除定制方案")
    @GetMapping("deleteCustomPlanById")
    ResponseDto<?> deleteCustomPlanById(@RequestHeader String token, @RequestParam Integer planId) {
        customPlanBiz.deleteCustomPlanById(planId);
        return new ResponseDto<>();
    }

    @ApiOperation("分页获取定制方案")
    @GetMapping("listCustomPlanByPage")
    ResponseDto<?> listCustomPlanByPage(@RequestHeader String token, @RequestParam Integer currentPage, @RequestParam Integer numPerPage,
                                        @RequestParam(value = "content", required = false) String content, @RequestParam(value = "useState", required = false) Integer useState) {
        return new ResponseDto<>(customPlanBiz.listCustomPlanByPage(currentPage, numPerPage, content, useState));
    }

    @ApiOperation("编辑方案模块")
    @PostMapping("editCustomPlanModule")
    ResponseDto<?> editCustomPlanModule(@RequestHeader String token, @RequestBody EditCustomPlanModuleVO editCustomPlanModuleVO) {
        customPlanBiz.editCustomPlanModule(editCustomPlanModuleVO);
        return new ResponseDto<>();
    }

    @ApiOperation("获取方案模块")
    @GetMapping("getCustomPlanModule")
    ResponseDto<?> getCustomPlanModule(@RequestHeader String token, @RequestParam Integer planId) {
        return new ResponseDto<>(customPlanBiz.getCustomPlanModule(planId));
    }

    @ApiOperation("获取方案模块(客户端)")
    @GetMapping("getCustomPlanModule4Wechat")
    ResponseDto<?> getCustomPlanModule4Wechat(@RequestParam Integer planId) {
        return new ResponseDto<>(customPlanBiz.getCustomPlanModule(planId));
    }

    @ApiOperation("分页获取定制方案问卷")
    @GetMapping("listPlanPaperByPage")
    ResponseDto<?> listPlanPaperByPage(@RequestHeader String token, @RequestParam Integer currentPage, @RequestParam Integer numPerPage,
                                       @RequestParam(value = "paperState", required = false) Integer paperState,
                                        @RequestParam(value = "content", required = false) String content) {
        return new ResponseDto<>(customPlanBiz.listPlanPaperByPage(currentPage, numPerPage, paperState, content));
    }

    @ApiOperation("作品或应用链接转短链")
    @GetMapping("getShortLinkUrl")
    ResponseDto<?> getShortLinkUrl(@RequestHeader String token, @RequestParam(value = "appId", required = false) Long appId,
                                   @RequestParam(value = "productId", required = false) Long productId,
                                   @RequestParam(value = "linkUrl") String linkUrl) {
        return new ResponseDto<>(customPlanBiz.getShortLinkUrl(appId, productId, linkUrl));
    }

    @ApiOperation("发送邮件提醒")
    @PostMapping("sendCustomPlanEmail")
    public ResponseDto<?> sendCustomPlanEmail(@RequestHeader("token") String token, @RequestBody CustomPlanEmailDto customPlanEmailDto)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(customPlanEmailBiz.sendCustomPlanEmail(customPlanEmailDto));
    }

    @ApiOperation("获取最后一次发送的邮件提醒")
    @GetMapping("getCustomPlanEmailByPlanId")
    public ResponseDto<?> getCustomPlanEmailByPlanId(@RequestHeader("token") String token, @RequestParam Integer customPlanId)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(customPlanEmailBiz.getCustomPlanEmailByPlanId(customPlanId));
    }

}
