package com.pcloud.book.personalstage.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * (PersonalStageProgressMessage)实体类
 *
 * @author zyq
 * @since 2020-02-24 15:57:48
 */
@Data
public class PersonalStageProgressMessage extends BaseEntity {

    private static final long serialVersionUID = 783203450632034209L;
    
    private String content;
    
    private Integer minutes;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date  progressTime;

    /**
     * 状态（0-未完成，1-已完成）
     */
    private Integer state;
    private Integer type;

}