package com.pcloud.book.personalstage.entity;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


@ApiModel("定制化回复")
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PersonalStageReply extends BaseEntity {

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("定制化阶段id")
    private Long personalStageId;

    @ApiModelProperty("关联id")
    private Long relevanceId;

    @ApiModelProperty("需求定制单id")
    private Long paperId;

    @ApiModelProperty("需求定制单标题")
    private String paperTitle;

    @ApiModelProperty("关联类型：1阶段非关键词回复，2非关键词熔断回复，3唤醒")
    private Integer relevanceType;

    @ApiModelProperty("回复项集合")
    private List<PersonalStageReplyItem> personalStageReplyItems;

}