package com.pcloud.book.push.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("个人号群发")
public class SelfPush extends BaseEntity{

    @ApiModelProperty("群发小号id")
    private String altId;

    @ApiModelProperty("小号名称")
    private String altName;

    private String altTypeName;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("立即发送")
    private Boolean sendNow;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开始时间")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("推送时间类型（1:每天发送 2:每周发送）")
    private Integer pushType;

    @ApiModelProperty("周几")
    private String weekDays;

    @ApiModelProperty("计划发送时间（不带日期）")
    private String pushSendTime;



    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("发送时间")
    private Date sendTime;

    @ApiModelProperty("bookGroupId")
    private Long bookGroupId;

    @ApiModelProperty("是否发送所有好友")
    private Boolean sendAll;

    @ApiModelProperty("个人号发送项集合")
    private List<SelfPushItem> pushItems;

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getPushType() {
        return pushType;
    }

    public void setPushType(Integer pushType) {
        this.pushType = pushType;
    }

    public String getWeekDays() {
        return weekDays;
    }

    public void setWeekDays(String weekDays) {
        this.weekDays = weekDays;
    }

    public String getPushSendTime() {
        return pushSendTime;
    }

    public void setPushSendTime(String pushSendTime) {
        this.pushSendTime = pushSendTime;
    }

    public String getAltId() {
        return altId;
    }

    public void setAltId(String altId) {
        this.altId = altId;
    }

    public String getAltName() {
        return altName;
    }

    public void setAltName(String altName) {
        this.altName = altName;
    }

    public String getAltTypeName() {
        return altTypeName;
    }

    public void setAltTypeName(String altTypeName) {
        this.altTypeName = altTypeName;
    }

    public List<SelfPushItem> getPushItems() {
        return pushItems;
    }

    public void setPushItems(List<SelfPushItem> pushItems) {
        this.pushItems = pushItems;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getSendNow() {
        return sendNow;
    }

    public void setSendNow(Boolean sendNow) {
        this.sendNow = sendNow;
    }

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public Boolean getSendAll() {
        return sendAll;
    }

    public void setSendAll(Boolean sendAll) {
        this.sendAll = sendAll;
    }
}