package com.pcloud.book.advertising.service;

import com.pcloud.book.advertising.dto.AdvertisingMasterBaseDTO;
import com.pcloud.book.advertising.dto.BrandDataDTO4Channel;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@FeignClient(value = "pcloud-service-book", qualifier = "advertisingSpaceServiceCloud", path = "book/v1.0/advertisingSpaceService")
@Api(description = "广告位内部接口")
public interface AdvertisingSpaceService {

    /**
     * 每日凌晨计算昨日广告位收益
     * @throws BizException
     */
    @ApiOperation(value = "每日凌晨计算昨日广告位收益", httpMethod = "GET")
    @RequestMapping(value = "calculateAdvertisingIncomeYesterday", method = RequestMethod.GET)
    void calculateAdvertisingIncomeYesterday() throws BizException;

    @ApiOperation("发送广告计划")
    @PostMapping("sendAdvertisingPlan")
    void sendAdvertisingPlan(@RequestBody Map<String, Object> map) throws BizException;

    @ApiOperation(value = "根据登录用户获取标记的微信群列表", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户登录id", dataType = "long", required = true, paramType = "query")
    @GetMapping("getTagWxGroupIdsByUserId")
    ResponseEntity<ResponseDto<List<String>>> getTagWxGroupIdsByUserId(@RequestParam("userId") Long userId);

    @ApiOperation(value = "查微信群标记的品牌方id", httpMethod = "GET")
    @ApiImplicitParam(name = "wxGroupId", value = "微信群id", dataType = "string", required = true, paramType = "query")
    @GetMapping("getBrandIdsByWxGroupId")
    ResponseEntity<ResponseDto<List<Long>>> getBrandIdsByWxGroupId(@RequestParam("wxGroupId") String wxGroupId);

    @ApiOperation("品牌方增加的二维码下资源数据")
    @PostMapping("mapBrandQrServeAddData")
    ResponseEntity<ResponseDto<Map<Long,BrandDataDTO4Channel>>> mapBrandQrServeAddData(@RequestBody @ApiParam BrandDataDTO4Channel brandDataDTO4Channel);

    @ApiOperation("品牌方增加的二维码数据")
    @PostMapping("mapBrandQrAddData")
    ResponseEntity<ResponseDto<Map<Long,BrandDataDTO4Channel>>> mapBrandQrAddData(@RequestBody @ApiParam BrandDataDTO4Channel brandDataDTO4Channel);

    @ApiOperation("获取所有广告主列表")
    @GetMapping("getAllMaster")
    ResponseEntity<ResponseDto<List<AdvertisingMasterBaseDTO>>> getAllMasterBaseInfo() throws BizException;
}
