package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 版次分析
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EditionAnalysisVO implements Serializable {

    @ApiModelProperty("出版时间最近的")
    private String closedDate;

    @ApiModelProperty("出版时间最早的")
    private String earliestDate;

    @ApiModelProperty("改版次数最高")
    private Integer maxEdition;

    @ApiModelProperty("改版书刊最多")
    private String maxBookCountDate;

    @ApiModelProperty("改版书刊最少")
    private String minBookCountDate;
}
