package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 小程序用户图书评价信息封装
 */
@Data
@ApiModel("小程序用户图书评价信息封装")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AppletBookUserScoreDTO {

    private Long wechatUserId;

    private Long scoreId;

    private String scoreName;

    @ApiModelProperty("是否选中")
    private boolean chosen = false;

    private List<AppletBookScoreTagDTO> tags;

}
