/**
 *
 */
package com.pcloud.book.book.dao.impl;

import cn.hutool.core.map.MapUtil;
import com.google.common.collect.Maps;
import com.pcloud.book.book.dao.BookDao;
import com.pcloud.book.book.dto.AdviserBookInfoDTO;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.BookInfo4AnlysicsDTO;
import com.pcloud.book.book.dto.BookInfoAnalysicsDTO;
import com.pcloud.book.book.entity.Book;
import com.pcloud.book.book.vo.BookSaleVO;
import com.pcloud.book.book.vo.SearchBookVO;
import com.pcloud.book.book.dto.BookUniqueNumberDTO;
import com.pcloud.book.es.entity.ESBookAndAdviser;
import com.pcloud.common.core.dao.BaseDaoImpl;
import com.pcloud.common.utils.ListForInSQL;
import com.pcloud.common.utils.ListUtils;
import io.swagger.models.auth.In;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：书籍数据访问层实现类
 * @作者：songx
 * @创建时间：2016年12月23日,下午2:58:15
 * @版本：1.0
 */
@Repository("bookDao")
public class BookDaoImpl extends BaseDaoImpl<Book> implements BookDao {

    /**
     * 批量删除
     */
    public Integer deleteByIds(List<Long> bookIds, Long deleteUserId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bookIds", bookIds);
        paramMap.put("lastModifiedUser", deleteUserId);
        return super.getSqlSession().update(super.getStatement("deleteByIds"), paramMap);
    }

    /**
     * 获取书籍基础信息
     */
    @Override
    public BookDto getBaseById(Long bookId) {
        return super.getSqlSession().selectOne(super.getStatement("getBaseById"), bookId);
    }

    /**
     * 根据ISBN获取图书信息
     */
    @Override
    public BookDto getByIsbnAndSnumContainsDelete(String isbn, String serialNumber) {
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("isbn", isbn);
        paramMap.put("serialNumber", serialNumber);
        return super.getSqlSession().selectOne(super.getStatement("getByIsbnAndSnumContainsDelete"), paramMap);
    }

    //	/**
    //	 * 根据ISBN获取图书信息
    //	 */
    //	@Override
    //	public BookDto getByIsbn(String isbn) {
    //		return super.getSqlSession().selectOne(super.getStatement("selectByIsbn"), isbn);
    //	}


    /**
     * 获取单个书籍基础信息(包含统计信息)
     */
    @Override
    public BookDto getById(Map<String, Object> paramMap) {
        return super.getSqlSession().selectOne(super.getStatement("getById"), paramMap);
    }

    /**
     * 批量获取书籍信息
     */
    @Override
    public Map<Long, BookDto> getMapByIds(List<Long> bookIds) {
        return super.getSqlSession().selectMap(super.getStatement("getMapByIds"), bookIds, "bookId");
    }

    /**
     * 批量获取书籍信息（书名 与书刊序号 封面图）
     */
    @Override
    public Map<Long, BookDto> listBaseMapByIds(List<Long> bookIds) {
        return super.getSqlSession().selectMap(super.getStatement("listBaseMapByIds"), bookIds, "bookId");
    }

    @Override
    public List<BookDto> listBookGroupByBookIds(List<Long> bookIds, List<Long> channelIds, List<Long> adviserIds) {
        return ListUtils.groupList4SQL(new ListForInSQL<BookDto>() {
            @Override
            public <T> List<T> processSQL(List<Long> list) {
                Map<String,Object> map = new HashMap<>();
                map.put("bookIds", list);
                map.put("channelIds", channelIds);
                map.put("adviserIds", adviserIds);
                return getSqlSession().selectList(getStatement("listBookGroupByBookIds"), map);
            }
        }, bookIds);
    }

    @Override
    public List<BookDto> listDetailByIds(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(super.getStatement("listDetailByIds"), paramMap);
    }

    /**
     * 根据名称获取ID
     */
    @Override
    public List<Long> getIdsByName(String bookName) {
        return super.getSqlSession().selectList(super.getStatement("getIdsByName"), bookName);
    }

    /**
     * 根据名称获取ID
     */
    @Override
    public List<Long> getIdsByNameMap(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(super.getStatement("getIdsByNameMap"), paramMap);
    }

    /**
     * 图书收益，获取书籍列表(编辑)
     */
    @Override
    public List<BookDto> getList4AdviserProfit(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(super.getStatement("getList4AdviserProfit"), paramMap);
    }

    /**
     * 根据刊物序号获取刊物信息
     */
    @Override
    public BookDto getBySerialNum(String serialNumber) {
        return super.getSqlSession().selectOne(super.getStatement("getBySerialNum"), serialNumber);
    }

    /**
     * 根据ISBN获取书刊信息（包含删除图书数据）
     */
    @Override
    public BookDto getByIsbn(String isbn) {
        return super.getSqlSession().selectOne(super.getStatement("getByIsbn"), isbn);
    }


    /**
     * 获取书籍详细信息（包含书籍关联二维码 商品 应用）
     */
    @Override
    public BookDto getDetailByIsbn(Map<String, Object> paramMap) {
        return super.getSqlSession().selectOne(super.getStatement("getDetailByIsbn"), paramMap);
    }

    /**
     * 获取书刊列表
     */
    @Override
    public List<BookDto> getListPage4Platform(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(super.getStatement("getListPage4Platform"), paramMap);
    }

    /**
     * 获取书籍总数
     */
    @Override
    public int getAllBookCount() {
        return super.getSqlSession().selectOne(super.getStatement("getAllBookCount"));
    }

    /**
     * 条件查询获取书籍总数
     */
    @Override
    public int getBookCount4Platform(Map<String, Object> paramMap) {
        return super.getSqlSession().selectOne(super.getStatement("getBookCount4Platform"), paramMap);
    }

    /**
     * 修改书籍封面图
     */
    @Override
    public void updateCoverImg(Book book) {
        super.getSqlSession().update(this.getStatement("updateCoverImg"), book);
    }

    /**
     * 获取应用关联图书
     */
    @Override
    public List<BookDto> listBookByAppId(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(this.getStatement("listBookByAppId"), paramMap);
    }

    /**
     * 删除图书
     */
    @Override
    public Integer deleteBook(Long bookId, Long deleteUserId) {
        Map<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("bookId", bookId);
        paramMap.put("lastModifiedUser", deleteUserId);
        return super.getSqlSession().update(this.getStatement("deleteBook"), paramMap);
    }

    /**
     * 获取出版下除默认生成图书的所有图书总数
     */
    @Override
    public Integer getAllBookCount4Agent(Map<String, Object> param) {
        return super.getSqlSession().selectOne(this.getStatement("getAllBookCount4Agent"), param);
    }

    /**
     * 根据isbn获取图书信息
     */
    @Override
    public Map<Long, BookDto> listByIsbn(String isbn) {
        return super.getSqlSession().selectMap(this.getStatement("listByIsbn"), isbn, "bookId");
    }

    /**
     * 获取图书总数除RAYS现代纸书
     */
    @Override
    public Integer getAllBookCount4Platform(Map<String, Object> param) {
        return super.getSqlSession().selectOne(this.getStatement("getAllBookCount4Platform"), param);
    }

    /**
     * 获取编辑图书模板
     */
    @Override
    public Long getTempletId(Long adviserId, Long channelId, Long bookId) {
        Map<String, Long> paramMap = new HashMap<>();
        paramMap.put("adviserId", adviserId);
        paramMap.put("channelId", channelId);
        paramMap.put("bookId", bookId);
        return super.getSqlSession().selectOne(this.getStatement("getTempletId"), paramMap);
    }

    /**
     * 修改图书基本信息
     */
    @Override
    public void updateByAdviser(Book book) {
        super.getSqlSession().update(this.getStatement("updateByAdviser"), book);
    }

    /**
     * 根据图书isbn和序号获取图书基本信息（不包含删除图书）
     * @param isbn
     * @param serialNumber
     * @return
     */
    public BookDto getByIsbnAndSnum(String isbn, String serialNumber) {
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("isbn", isbn);
        paramMap.put("serialNumber", serialNumber);
        return super.getSqlSession().selectOne(this.getStatement("getByIsbnAndSnum"), paramMap);
    }

    @Override
    public List<BookDto> getList4Adviser(Map<String, Object> param) {
        return super.getSqlSession().selectList(this.getStatement("getListPage4Adviser"), param);
    }

    @Override
    public void updateTimeById(Map<String, Object> param) {
        super.getSqlSession().update(super.getStatement("updateTimeById"), param);
    }

    @Override
    public void updateTimeByIds(Map<String, Object> param) {
        super.getSqlSession().update(super.getStatement("updateTimeByIds"), param);
    }

    @Override
    public List<BookInfoAnalysicsDTO> getBookInfoBy(Map<String, Object> param) {
        return super.getSqlSession().selectList(this.getStatement("getBookInfoBy"), param);
    }

    @Override
    public List<BookInfo4AnlysicsDTO> getBookAnalysis(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(this.getStatement("getBookAnalysis"), paramMap);
    }

    @Override
    public List<BookDto> listBookIdAndChannelId4Adviser(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("listBookIdAndChannelId4Adviser"), paramMap);
    }

    /**
     * 获取社群书列表
     */
    @Override
    public List<BookDto> listSimpleBookGroup4Adviser(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("listSimpleBookGroup4Adviser"), paramMap);
    }

    @Override
    public List<BookDto> listBookGroup4Adviser(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("listBookGroup4Adviser"),paramMap);
    }

    @Override
    public List<Long> getIdsByNameOrISBN(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(super.getStatement("getIdsByNameOrISBN"), paramMap);
    }

    @Override
    public Long listBookClassifyCount(Map<String, Object> paramMap) {
        return super.getSqlSession().selectOne(super.getStatement("listBookClassifyCount"), paramMap);
    }

    @Override
    public List<BookSaleVO> listIncomePage4Agent(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(super.getStatement("listIncomePage4Agent"), paramMap);
    }

    @Override
    public Long countIncomePage4Agent(Map<String, Object> paramMap) {
        return super.getSqlSession().selectOne(super.getStatement("countIncomePage4Agent"), paramMap);
    }

    @Override
    public List<Long> getBookIdsByBookName(String bookName) {
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("bookName", bookName);
        return super.getSqlSession().selectList(getStatement("getBookIdsByBookName"),paramMap);
    }

    @Override
    public BookDto getAdviserBookByName(String bookName) {
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("bookName", bookName);
        return super.getSqlSession().selectOne(getStatement("getAdviserBookByName"),paramMap);
    }

    @Override
    public List<Long> getBookIdsByIsbn(String isbn) {
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("isbn", isbn);
        return super.getSqlSession().selectOne(getStatement("getBookIdsByIsbn"),paramMap);
    }

    @Override
    public void updateBookQualifyInfo(Map<String, Object> map) {
        super.getSqlSession().update(super.getStatement("updateBookQualifyInfo"), map);
    }

    @Override
    public SearchBookVO getBookInfoByBookGroupId(Map<String, Object> paramMap) {
        return super.getSqlSession().selectOne(super.getStatement("getBookInfoByBookGroupId"), paramMap);
    }

    @Override
    public void updateIsOpenRobotProcess(Map<String, Object> paramMap) {
        super.getSqlSession().update(super.getStatement("updateIsOpenRobotProcess"), paramMap);
    }

    @Override
    public Integer count() {
        return super.getSqlSession().selectOne(getStatement("count"));
    }

    @Override
    public List<ESBookAndAdviser> findAllBookAndAdviser(Long maxId, Integer offset) {
        Map<String, Object> map = new HashMap<>();
        map.put("maxId", maxId);
        map.put("offset", offset);
        return super.getSqlSession().selectList(getStatement("findAllBookAndAdviser"), map);
    }

    @Override
    public List<ESBookAndAdviser> findBookAndAdviserByBookIds(List<Long> bookIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookIds", bookIds);
        return super.getSqlSession().selectList(getStatement("findBookAndAdviserByBookIds"), map);
    }

    @Override
    public Map<Long, BookDto> getMapByBookIds(List<Long> bookIds) {
        return super.getSqlSession().selectMap(super.getStatement("getMapByBookIds"), bookIds, "bookId");
    }

    @Override
    public BookDto getBookByName(String bookName) {
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("bookName", bookName);
        return super.getSqlSession().selectOne(getStatement("getBookByName"),paramMap);
    }


    @Override
    public List<AdviserBookInfoDTO> getBookAdviserInfos(List<Long> bookIds) {
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("bookIds", bookIds);
        return super.getSqlSession().selectList(getStatement("getBookAdviserInfos"),paramMap);
    }

    @Override
    public void relateUniqueNumber4Erp(List<BookUniqueNumberDTO> bookUniqueNumberVos) {
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("bookUniqueNumberVos", bookUniqueNumberVos);
        super.getSqlSession().update(getStatement("relateUniqueNumber4Erp"),paramMap);
    }

    @Override
    public void updateByPrimaryKeySelective(Book book){
        super.getSqlSession().update(getStatement("updateByPrimaryKeySelective"), book);
    }

    @Override
    public Integer checkIsGroupBook(Long bookId) {
        return getSqlSession().selectOne(getStatement("checkIsGroupBook"), MapUtil.of("bookId", bookId));
    }

    @Override
    public BookDto getBaseById4Buy(Map<String, Object> paramMap) {
        return getSqlSession().selectOne(getStatement("getBaseById4Buy"),paramMap);
    }

    @Override
    public List<Long> getByIds(List<Long> bookIds) {
        return getSqlSession().selectList(getStatement("getByIds"), bookIds);
    }

    @Override
    public List<BookDto> listPageBookMinimunSupport4Platform(Map<String, Object> paramMap) {
        return getSessionTemplate().selectList(getStatement("listPageBookMinimunSupport4Platform"), paramMap);
    }

    @Override
    public Integer getBookMinimunSupportCount4Platform(Map<String, Object> paramMap){
        return getSessionTemplate().selectOne(getStatement("getBookMinimunSupportCount4Platform"), paramMap);
    }

    @Override
    public Integer getFundBookCounts(List<Long> advisers, int month) {
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("list", advisers);
        paramMap.put("month", month);
        return getSessionTemplate().selectOne(getStatement("getFundBookCounts"), paramMap);
    }

    @Override
    public Integer getBookCountByAdviserId(Long adviserId) {
        return getSessionTemplate().selectOne(getStatement("getBookCountByAdviserId"), adviserId);
    }

    @Override
    public boolean checkIsBookId(Long isbnNumber) {
        return getSessionTemplate().selectOne(getStatement("checkIsBookId"), isbnNumber);
    }
}
