package com.pcloud.book.book.vo.response;

import com.pcloud.book.applet.dto.AppletGroupStatementDTO;
import com.pcloud.common.dto.BaseDto;

import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName com.pcloud.book.book.vo.response.BookQrcodeWxworkResponseVO
 * @Author zhuyajie
 * @Description 企业微信码配置
 * @Date 2020/12/23 10:58
 * @Version 1.0
 **/
@Data
public class BookQrcodeWxworkResponseVO extends BaseDto {

    /**
     * 企业微信活码id
     */
    private Long wxworkQrcodeId;
    /**
     * 二维码名称
     */
    private String wxworkQrcodeName;
    /**
     * 二维码
     */
    private String wxworkQrcodeUrl;
    /**
     * 小睿引导添加语
     */
    private String guideRays;
    /**
     * 公众号引导添加语
     */
    private String guideAccounts;
    /**
     * 企业微信二维码类型（1sop活码2群活码）
     */
    private Integer wxworkQrcodeType;

    /**
     * 小睿邀请语
     */
    private String invitationRays;
    /**
     * 公众号邀请语
     */
    private String invitationAccounts;
    /**
     * 群头像
     */
    private List<String> headUrlList;
    /**
     * 群对话
     */
    private List<AppletGroupStatementDTO> statementDTOList;

    @ApiModelProperty("群名称")
    private String groupName;

    @ApiModelProperty("群描述")
    private String groupDesc;
    /**
     * 二维码原始链接
     */
    private String url;

}
