package com.pcloud.book.group.biz.impl;

import com.pcloud.book.group.biz.BookClassifyBuyRecordBiz;
import com.pcloud.book.group.biz.BookGroupClassifyBiz;
import com.pcloud.book.group.dao.BookClassifyBuyRecordDao;
import com.pcloud.book.group.dto.ClassifyDTO;
import com.pcloud.book.group.entity.BookClassifyBuyRecord;
import com.pcloud.common.core.aspect.ParamLog;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author lily
 * @date 2019/4/19 11:28
 */
@Component("bookClassifyBuyRecordBiz")
public class BookClassifyBuyRecordBizImpl implements BookClassifyBuyRecordBiz {

    @Autowired
    private BookGroupClassifyBiz bookGroupClassifyBiz;

    @Autowired
    private BookClassifyBuyRecordDao bookClassifyBuyRecordDao;

    @Override
    @ParamLog("新增记录")
    public void insertRecord(BookClassifyBuyRecord bookClassifyBuyRecord) {
        //通过规格id拿对应信息
        ClassifyDTO classifyDTO = bookGroupClassifyBiz.getBaseInfoBySpecId(bookClassifyBuyRecord.getProductSpecId());
        if (classifyDTO == null) {
            return;
        }
        bookClassifyBuyRecord.setBookId(classifyDTO.getBookId());
        bookClassifyBuyRecord.setChannelId(classifyDTO.getChannelId());
        bookClassifyBuyRecord.setClassifyId(classifyDTO.getId());
        bookClassifyBuyRecord.setBookQrcodeId(classifyDTO.getBookGroupId());
        bookClassifyBuyRecordDao.insert(bookClassifyBuyRecord);
    }

    @Override
    @ParamLog("校验用户是否购买")
    public Boolean checkUserBuy(Long wechatUserId, Long classifyId) {
        return bookClassifyBuyRecordDao.checkUserBuy(wechatUserId, classifyId);
    }
}
