package com.pcloud.book.personalstage.entity;

import com.pcloud.common.entity.BaseEntity;
import com.pcloud.contentcenter.resource.dto.ResourceOfficeItemDTO;
import com.pcloud.contentcenter.resource.dto.ResourcePdfItemDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel("定制化阶段回复项")
@Data
public class PersonalStageReplyItem extends BaseEntity {

    @ApiModelProperty("定制化阶段回复id")
    private Long personalStageReplyId;

    @ApiModelProperty("回复类型 1 文字 2 图片 3 链接 4应用 5素材")
    private Integer replyType;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("图片地址")
    private String picUrl;

    @ApiModelProperty("资源id")
    private Long resourceId;
    
    @ApiModelProperty("资源链接")
    private String resourceUrl;

    @ApiModelProperty("资源名称")
    private String resourceName;

    @ApiModelProperty("资源类型编码")
    private String resourceTypeCode;

    @ApiModelProperty("资源类型名称")
    private String resourceTypeName;

    @ApiModelProperty("文件类型")
    private String fileType;

    @ApiModelProperty("pdf转码后的单张图片集合")
    private List<ResourcePdfItemDTO> resourcePdfItems;

    @ApiModelProperty("文件转码后的单张图片集合")
    private List<ResourceOfficeItemDTO> resourceOfficeItemDTOs;

    @ApiModelProperty("文件大小")
    private Long fileSize;

}