package com.pcloud.book.book.dao.impl;

import com.google.common.collect.Maps;

import com.pcloud.book.book.dao.KeywordWarehouseDao;
import com.pcloud.book.book.entity.KeywordWarehouse;
import com.pcloud.book.book.vo.request.CheckKeywordRequestVO;
import com.pcloud.book.book.vo.response.CheckKeywordResponseVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public class KeywordWarehouseDaoImpl extends BaseDaoImpl<KeywordWarehouse> implements KeywordWarehouseDao {
    @Override
    public int insertSelective(KeywordWarehouse record) {
        return this.getSqlSession().insert("com.pcloud.book.book.dao.impl.KeywordWarehouseDaoImpl.insertSelective", record);
    }

    @Override
    public KeywordWarehouse selectByPrimaryKey(Long id) {
        return this.getSqlSession().selectOne("com.pcloud.book.book.dao.impl.KeywordWarehouseDaoImpl.selectByPrimaryKey", id);
    }

    @Override
    public int updateByPrimaryKeySelective(KeywordWarehouse record) {
        return this.getSqlSession().update("com.pcloud.book.book.dao.impl.KeywordWarehouseDaoImpl.updateByPrimaryKeySelective", record);
    }

    @Override
    public int updateByPrimaryKey(KeywordWarehouse record) {
        return this.getSqlSession().update("com.pcloud.book.book.dao.impl.KeywordWarehouseDaoImpl.updateByPrimaryKey", record);
    }

    @Override
    public List<KeywordWarehouse> listByIds(List<Long> ids) {
        return this.getSqlSession().selectList("com.pcloud.book.book.dao.impl.KeywordWarehouseDaoImpl.listByIds", ids);
    }


    @Override
    public List<CheckKeywordResponseVO> checkKeyword(CheckKeywordRequestVO vo) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("keyword", vo.getKeyword());
        map.put("list", vo.getDepthLabelIds());
        return this.getSqlSession().selectList("com.pcloud.book.book.dao.impl.KeywordWarehouseDaoImpl.checkKeyword", map);
    }

}
