package com.pcloud.book.group.handler;

import com.pcloud.book.group.biz.BookGroupBiz;
import com.pcloud.common.utils.DateUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Random;

import javax.annotation.PostConstruct;

/**
 * @Description 启动时开始推送1v1更新
 * @Author ruansiyuan
 * @Date 2019/10/28 16:36
 **/
@Component
public class PushBookGroupUpdateHandler {


    private static final Logger LOGGER = LoggerFactory.getLogger(PushBookGroupUpdateHandler.class);

    private static PushBookGroupUpdateHandler pushBookGroupUpdateHandler;

    @Autowired
    private BookGroupBiz bookGroupBiz;

    private static Thread thread = new Thread(new Runnable() {
        @Override
        public void run() {
            while (true) {
                //随机睡10到15s
                Long sleepMillis = Double.valueOf(new Random().nextInt(10) + 5).longValue() * 1000;
                try {
                    //判断是否是早八点到晚八点之间
                    Boolean isInTime = DateUtils.isInBetweenTimes("08:00:00", "20:00:00");
                    if (isInTime) {
                        pushBookGroupUpdateHandler.bookGroupBiz.pushBookGroupUpdate();
                    }
                    Thread.sleep(sleepMillis);
                } catch (Throwable e) {
                    LOGGER.error("启动时开始推送1v1更新异常" + e.getMessage(), e);
                }
            }
        }
    });

    static {
        thread.start();
    }

    @PostConstruct
    public void init() {
        pushBookGroupUpdateHandler = this;
        pushBookGroupUpdateHandler.bookGroupBiz = this.bookGroupBiz;
    }

    public static Thread getInstance() {
        return thread;
    }



}
