package com.pcloud.book.book.vo;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author lily
 * @date 2018/12/3 21:24
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
@Data
public class ErpAdviserBookVO implements Serializable {

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("编辑标识")
    private Long adviserId;

    @ApiModelProperty("渠道标识")
    private Long channelId;

    @ApiModelProperty("图书名称")
    private String bookName;

    @ApiModelProperty("封面图")
    private String coverImg;

    @ApiModelProperty("isbn")
    private String isbn;

    @ApiModelProperty("编号")
    private  String uniqueNumber;

    @ApiModelProperty("编辑名称")
    private String adviserName;

    private Long bookAdviserId;

    private String channelName;

    @ApiModelProperty("编辑所属出版社")
    private String agentName;

    private Boolean isFundSupport;

    private String adviserAccount;

    private String adviserPwd;

    @ApiModelProperty("序号")
    private String serialNumber;

}
