package com.pcloud.book.giftcoupon.dao;

import com.pcloud.book.giftcoupon.entity.GiftCouponPackage;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;


/**
 * 专享礼券包表(GiftCouponPackage)表数据库访问层
 *
 * @author makejava
 * @since 2020-04-19 14:59:21
 */
public interface GiftCouponPackageDao extends BaseDao<GiftCouponPackage> {


    Map<Long,GiftCouponPackage> getMapByIds(List<Long> list);

    List<Long> getPackageIdsBy(List<Long> packageIds);

    Integer getNoStockCount(List<Long> packageIds);

    void reduceStock(Long id);

    void reduceStockBatch(List<Long> packageIds);

    String getUrlNumberByAddress(String exchangeAddress, Long agentId);

    /**
     * 链接编号是否存在
     * @author：zhuyajie
     * @date：2020/5/11 18:43
     *  * @param null
     */
    Boolean urlNumberExist(String exchangeAddress, String urlNumber, Long id, Long agentId);
}