package com.pcloud.book.cultivate.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.cultivate.entity.CultivateNotifyItem;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class CultivateNotifyPageDTO {
    @ApiModelProperty("消息类型（1-系统消息，2-通知消息，3-提醒消息，4-活动消息）")
    private Integer messageType;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("消息Id")
    private Long messageId;

    @ApiModelProperty("发送类型（1-指定用户，2-分类用户，3-按书籍查询，4-全局公告消息）")
    private Integer sendType;

    @ApiModelProperty("发送内容")
    private List<CultivateNotifyItem> cultivateNotifyItems;

    @ApiModelProperty("发送时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sendTime;

    @ApiModelProperty("是否首页弹窗")
    private Integer showHome;

}
