package com.pcloud.book.cultivate.service.impl;

import com.pcloud.book.cultivate.biz.CultivateNotifyBiz;
import com.pcloud.book.cultivate.dto.NotifySendDTO;
import com.pcloud.book.cultivate.entity.AppletNotifySendDTO;
import com.pcloud.book.cultivate.entity.CultivateNotifySend;
import com.pcloud.book.cultivate.service.CultivateNotifyService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;

import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController("cultivateNotifyService")
@RequestMapping("cultivateNotifyService")
public class CultivateNotifyServiceImpl implements CultivateNotifyService {

    @Autowired
    private CultivateNotifyBiz cultivateNotifyBiz;

    @Override
    @RequestMapping(value = "/batchSendMiniUser", method = RequestMethod.POST)
    public void batchSendMiniUser(@RequestBody List<CultivateNotifySend> list) throws BizException {
        if (!ListUtils.isEmpty(list)) {
            cultivateNotifyBiz.batchSendMiniUser(list);
        }
    }

    @Override
    @RequestMapping(value = "sendAppletUserNotify", method = RequestMethod.POST)
    public void sendAppletUserNotify(@RequestBody List<CultivateNotifySend> list) throws BizException{
        if (!ListUtils.isEmpty(list)) {
            cultivateNotifyBiz.sendAppletUserNotify(list);
        }
    }

    @Override
    @RequestMapping(value = "createNotify4Question", method = RequestMethod.POST)
    public  ResponseEntity<ResponseDto<Long>> createNotify4Question(@RequestBody AppletNotifySendDTO newSendDTO)  throws BizException{
        return ResponseHandleUtil.toResponse(cultivateNotifyBiz.createNotify4Question(newSendDTO));
    }

    @RequestMapping(value = "createNotify4App", method = RequestMethod.POST)
    public  ResponseEntity<ResponseDto<Long>> createNotify4App(@RequestBody AppletNotifySendDTO newSendDTO)  throws BizException{
        return ResponseHandleUtil.toResponse(cultivateNotifyBiz.createNotify4App(newSendDTO));
    }

    @Override
    @PostMapping("sendNotifyToUser")
    public ResponseEntity<ResponseDto<Long>> sendNotifyToUser(@RequestBody NotifySendDTO notifySendDTO) {
        return ResponseHandleUtil.toResponse(cultivateNotifyBiz.sendNotifyToUser(notifySendDTO));
    }
}
