package com.pcloud.book.es.biz;

import com.pcloud.book.book.vo.request.BookSearchParamVO;
import com.pcloud.book.es.entity.ESBookAndAdviser;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2020/4/13 12:21
 **/
public interface ESBookAndAdviserBiz {
    void addAllBookAndAdviserToES();

    void updateBookAndAdviserToES(List<Long> bookIds);

    Page<ESBookAndAdviser> getAdviserBooks4ES(String grayStatus, String keyword, Long templetId, Long secondTempletId, Long thirdTempletId, Integer currentPage, Integer numPerPage);

    Page<ESBookAndAdviser> getESAdviserBooks4Applet(String grayStatus, String keyword, List<Long> templetIds, List<Long> graLabelIds, List<Long> subLabelIds, Integer currentPage, Integer numPerPage, List<Long> scecondTempletIds, Integer isAdviserBook, List<Long> adviserIds, Long agentId);

    Page<ESBookAndAdviser> getESAdviserBooks4AppletV2(String grayStatus, String keyword, List<Long> templetIds, List<Long> graLabelIds, List<Long> subLabelIds, Integer currentPage, Integer numPerPage, List<Long> scecondTempletIds, List<Long> adviserIds, Long agentId);

    void deleteAdviserBooks4ES();

    void deleteChoosedAdviserBooks4ES(String keyword);

    /**
     * 答案，搜索全平台书刊
     * @author：zhuyajie
     * @date：2020/11/4 13:52
     *  * @param null
     */
    Page<ESBookAndAdviser> getESAdviserBooks4Answer(BookSearchParamVO bookSearchParamVO);
    /**
     * 系列书搜索
     * @author：zhuyajie
     * @date：2020/11/23 17:26
     *  * @param null
     */
    Page<ESBookAndAdviser> getAdviserBooks4SeriesBook(List<String> keywords, Integer currentPage, Integer numPerPage, List<Long> adviserIds, Long agentId, Long subLabelId, Long graLabelId, String serialNumber, Long verLabelId, Long volLabelId);

    Map<String, Object> getNotFoundBookId(String lastBookId)throws Exception;

    void stopNotFoundBookId();

    void updateTempletId();

    /**
     * 查所有书刊，选中的在前
     * @author：zhuyajie
     * @date：2021/4/16 14:34
     *  * @param null
     */
    Page<ESBookAndAdviser> getESBooksOrderByChose(String keyword, List<Long> choseBookIdList, Integer currentPage, Integer numPerPage);

    /**
     * 获取编辑书刊列表(ERP项目用)
     */
    Page<ESBookAndAdviser> getESBooks4Erp(String isbn, String uniqueNumber, List<String> listName, List<Long> adviserIdList, Integer currentPage, Integer numPerPage);
}
