package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.ResourcePageColumnDao;
import com.pcloud.book.group.entity.ResourcePageColumn;
import com.pcloud.book.group.vo.ResourceColumnAndServeVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.group.dao.impl.ResourcePageColumnDaoImpl
 * @Author zhuyajie
 * @Description 自有码H5页面栏目
 * @Date 2021/3/26 15:31
 * @Version 1.0
 **/
@Component
public class ResourcePageColumnDaoImpl extends BaseDaoImpl<ResourcePageColumn> implements ResourcePageColumnDao {
    @Override
    public Integer getMaxSeq(Long resourcePageId) {
        return getSessionTemplate().selectOne(getStatement("getMaxSeq"),resourcePageId);
    }

    @Override
    public List<ResourceColumnAndServeVO> getColumnListByPageId(Long resourcePageId) {
        return getSessionTemplate().selectList(getStatement("getColumnListByPageId"), resourcePageId);
    }

    @Override
    public List<ResourcePageColumn> getByColumnTypeAndPage(Long resourcePageId, Integer columnType) {
        Map<String, Object> map = new HashMap<>();
        map.put("resourcePageId", resourcePageId);
        map.put("columnType", columnType);
        return getSessionTemplate().selectList(getStatement("getByColumnTypeAndPage"), map);
    }

    @Override
    public void updateColumnSeqNum(Long id, Integer columnSeq) {
        Map<String, Object> map = new HashMap<>();
        map.put("columnSeq", columnSeq);
        map.put("id", id);
        getSessionTemplate().update(getStatement("updateColumnSeqNum"), map);
    }

    @Override
    public ResourcePageColumn getColumByMoveType(String moveType, Long resourcePageId, Integer columnSeq) {
        Map<String, Object> map = new HashMap<>();
        map.put("moveType", moveType);
        map.put("resourcePageId", resourcePageId);
        map.put("columnSeq", columnSeq);
        return getSessionTemplate().selectOne(getStatement("getColumByMoveType"), map);
    }

    @Override
    public void updateSeq4Batch(List<ResourceColumnAndServeVO> list) {
        getSessionTemplate().update(getStatement("updateSeq4Batch"), list);
    }

    @Override
    public void deleteByPageId(Long resourcePageId) {
        getSessionTemplate().delete(getStatement("deleteByPageId"), resourcePageId);
    }
}
