package com.pcloud.book.group.facade;

import com.pcloud.book.group.entity.LearningReportBrowseRecord;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

@Api(description = "学习报告")
public interface LearningReportFacade {


    @ApiOperation("新增学习报告浏览记录")
    @PostMapping("createLearningReportBrowseRecord")
    ResponseDto<?> createLearningReportBrowseRecord(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam("学习报告浏览记录") LearningReportBrowseRecord learningReportBrowseRecord
    ) throws BizException, PermissionException;

    @ApiOperation("获取最近学习记录")
    @GetMapping("getRecentlyLearning")
    ResponseDto<?> getRecentlyLearning(
            @CookieValue("userInfo") String userInfo,
            @RequestParam @ApiParam("群id") Long qrcodeId
    ) throws BizException, PermissionException;

    @ApiOperation("获取学习元气值前五名")
    @GetMapping("getLearningTopFive")
    ResponseDto<?> getLearningTopFive(
            @CookieValue("userInfo") String userInfo,
            @RequestParam @ApiParam("群id") Long qrcodeId
    ) throws BizException, PermissionException;

    @ApiOperation("获取微信用户元气值")
    @GetMapping("getUserLearningSore")
    ResponseDto<?> getUserLearningSore(
            @CookieValue("userInfo") String userInfo,
            @RequestParam @ApiParam("群id") Long qrcodeId
    ) throws BizException, PermissionException;

    @ApiOperation("获取微信用户榜单")
    @GetMapping("getUserLearningInfo")
    ResponseDto<?> getUserLearningInfo(
            @CookieValue("userInfo") String userInfo,
            @RequestParam @ApiParam("群id") Long qrcodeId,
            @RequestParam @ApiParam("生成二维码的链接") String qrcodeUrlS
    ) throws BizException, PermissionException;
}
