package com.pcloud.book.rightsSetting.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * (RightsSettingItemDetail)实体类
 *
 * @author makejava
 * @since 2020-05-18 22:28:12
 */
@Data
public class RightsSettingItemDetail extends BaseEntity {

    private static final long serialVersionUID = 861375509249616760L;
    
    @ApiModelProperty("即享权益项id")
    private Long id;
    
    @ApiModelProperty("权益子项id")
    private Long rightsSettingItemId;
    
    @ApiModelProperty("社群或资讯id")
    private Long serveId;
    
    @ApiModelProperty("社群、资讯")
    private String serveType;
    
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("群类型 2:编辑端群")
    private Integer groupType;

    @ApiModelProperty("应用链接")
    private String linkUrl;
    
}