package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.group.vo.ListClassify4WechatVO;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * (AppletGroupSearchRecord)实体类
 *
 * @author zyq
 * @since 2020-04-01 17:34:47
 */
@Data
public class AppletGroupSearchRecordDTO implements Serializable {

    private Long id;
    
    @ApiModelProperty("社群码id")
    private Long bookGroupId;
    
    @ApiModelProperty("用户id")
    private Long wechatUserId;
    
    @ApiModelProperty("图书id")
    private Long bookId;
    
    @ApiModelProperty("运营id")
    private Long channelId;
    
    @ApiModelProperty("编辑id")
    private Long adviserId;

    @ApiModelProperty("书籍名称")
    private String bookName;

    @ApiModelProperty("出版社")
    private String publish;

    @ApiModelProperty("作者")
    private String author;

    @ApiModelProperty("简介")
    private String remark;

    @ApiModelProperty("书籍封面")
    private String coverImg;

    @ApiModelProperty("交流群个数")
    private Integer classifyCount;

    @ApiModelProperty("群分类信息")
    private List<ListClassify4WechatVO> classify4WechatVOList;

}