/**
 * 
 */
package com.pcloud.book.book.service.impl;

import com.pcloud.book.book.biz.BookAdviserBiz;
import com.pcloud.book.book.biz.BookRaysClassifyBiz;
import com.pcloud.book.book.dto.*;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.book.book.service.BookAdviserService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @描述：编辑推广书籍接口类实现类
 * @作者：songx
 * @创建时间：2017年1月4日,下午7:59:13 @版本：1.0
 */
@RestController("bookAdviserService")
@RequestMapping("bookAdviserService")
public class BookAdviserServiceImpl implements BookAdviserService {

	@Autowired
	private BookAdviserBiz bookAdviserBiz;
	@Autowired
    private BookRaysClassifyBiz bookRaysClassifyBiz;


	@Override
	@GetMapping(value = "/listByAdviserId")
	public ResponseEntity<ResponseDto<List<BookDto>>> listByAdviserId(@RequestParam("adviserId") Long adviserId) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.listByAdviserId(adviserId));
	}

    @Override
	@GetMapping("getXiaoRuiClassifyIdByBookId")
	public ResponseEntity<ResponseDto<Long>> getXiaoRuiClassifyIdByBookId(@RequestParam("bookId") Long bookId,
																   @RequestParam("channelId") Long channelId,
																   @RequestParam("adviserId") Long adviserId) throws BizException{
        Long classifyIdByBookId = bookRaysClassifyBiz.getClassifyId(bookId, adviserId, channelId);
        return ResponseHandleUtil.toResponse(classifyIdByBookId);
    }

    /**
	 * 获取编辑的推广书籍总数
	 */
	@Override
	@RequestMapping(value = "/getCountByAdvisers", method = RequestMethod.POST)
	public ResponseEntity<ResponseDto<Map<Long, BookAdviserDto>>> getCountByAdvisers(
			@RequestBody(required = false) List<Long> adviserIds) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getCountByAdvisers(adviserIds));
	}

	/**
	 * 根据ISBN获取书籍信息
	 */
	@Override
	@RequestMapping(value = "/getByIsbn", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<BookAdviserDto>> getByIsbn(
			@RequestParam(value = "isbn", required = false) String isbn,
			@RequestParam(value = "channelId", required = false) Long channelId) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getByIsbn(isbn, channelId));
	}

	/**
	 * 根据图书信息获取主编辑ID
	 */
	@Override
	@RequestMapping(value = "/getMainAdviserId", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<Long>> getMainAdviserId(
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getMainAdviserId(bookId, channelId));
	}

	/**
	 * 创建默认图书与编辑的关系
	 */
	@Override
	@RequestMapping(value = "/createDefaultBook", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<Long>> createDefaultBook(
			@RequestParam(value = "adviserId", required = false) Long adviserId) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.createDefaultBook(null, adviserId));
	}

	/**
	 * 设置图书使用模板
	 */
	@Override
	@RequestMapping(value = "/setBookTemplet", method = RequestMethod.POST)
	public void setBookTemplet(@RequestBody BookAdviser bookAdviser) throws BizException {
		bookAdviserBiz.setBookTemplet(bookAdviser);
	}

	@Override
	@PostMapping("listAdviserBookInfo")
	public ResponseEntity<ResponseDto<Map<String,AdviserBookInfoDTO>>> listAdviserBookInfo(@RequestBody AviserBookInfoParam AviserBookInfoParam) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.listAdviserBookInfo(AviserBookInfoParam));
	}

	@Override
	@PostMapping("getBookCountByAdviserId")
	public ResponseEntity<ResponseDto<Map<Long, BookCountAndAdviserIdDTO>>> getBookCountByAdviserId(@RequestBody BookCountByAdvisersDto bookCountByAdvisersDto) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getBookCountByAdviserId(bookCountByAdvisersDto));
	}

	@Override
	@GetMapping("refactorData")
	public ResponseEntity<ResponseDto<String>> refactorData(@RequestParam("parentId") Long parentId,
															@RequestParam("originTempletId") Long originTempletId,
															@RequestParam(value = "secondTempletId",required = false) Long secondTempletId) throws BizException {
		if(Objects.isNull(parentId) || Objects.isNull(originTempletId)){
			return ResponseHandleUtil.toResponse("param is wrong");
		}

		bookAdviserBiz.refactorData(parentId,originTempletId,secondTempletId);
		return ResponseHandleUtil.toResponse("ok");
	}

	@Override
	@GetMapping("getBookRightsSetting")
	public ResponseEntity<ResponseDto<BookRightsSettingDTO>>getBookRightsSetting(
			@RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId,
			@RequestParam("adviserId") Long adviserId) {
		BookRightsSettingDTO bookRightsSettingDTO = bookAdviserBiz.getBookRightsSetting(bookId,channelId,adviserId);
		return ResponseHandleUtil.toResponse(bookRightsSettingDTO);
	}
}
