package com.pcloud.book.consumer.wechatgroup;

import com.dcg.coolq.sdk.CoolQSDK;
import com.dcg.coolq.sdk.message.vos.send.PrivateMsgSendVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.common.utils.json.JSONUtils;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.wechatgroup.group.dto.GroupMemberStatisDTO;
import com.pcloud.wechatgroup.group.dto.GroupRobotDTO;
import com.pcloud.wechatgroup.group.dto.GroupUserCountDTO;
import com.pcloud.wechatgroup.group.dto.GroupUserDTO;
import com.pcloud.wechatgroup.group.dto.RobotReplyDTO;
import com.pcloud.wechatgroup.group.service.GroupMemberService;
import com.pcloud.wechatgroup.message.dto.BrandParamDTO;
import com.pcloud.wechatgroup.message.dto.GroupChatCountDTO;
import com.pcloud.wechatgroup.message.dto.GroupMsgCountDTO;
import com.pcloud.wechatgroup.message.dto.GroupStatistics;
import com.pcloud.wechatgroup.message.dto.LinkGroupParamDTO;
import com.pcloud.wechatgroup.message.dto.UserChatCountDTO;
import com.pcloud.wechatgroup.message.service.MessageService;
import com.pcloud.wechatgroup.monitor.service.MonitorService;
import com.pcloud.wechatgroup.selfrobot.dto.*;
import com.pcloud.wechatgroup.selfrobot.service.SelfRobotService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component("wechatGroupConsr")
public class WechatGroupConsr {

    @Autowired
    private GroupMemberService groupMemberService;

    @Autowired
    private MessageService messageService;
    @Autowired
    private MonitorService monitorService;
    @Autowired
    private SelfRobotService selfRobotService;

    @ParamLog("根据机器人id和用户微信id获取最新暗号")
    public String getCipherByRobotAndUserWxId(String robotWxId, String userWxId) {
        if (StringUtil.isBlank(robotWxId) || StringUtil.isBlank(userWxId)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseResponse(selfRobotService.getCipherByRobotAndUserWxId(robotWxId, userWxId), String.class);
        } catch (BizException e) {
            log.warn("根据机器人id和用户微信id获取最新暗号失败:" + e.getMessage(), e);
            throw new BizException(e.getCode(), e.getMessage());
        } catch (Exception e) {
            log.error("根据机器人id和用户微信id获取最新暗号.[getCipherByRobotAndUserWxId]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_RES_ERROR, "服务内部错误，请稍后重试");
        }
    }

    @ParamLog("是否群机器人")
    public Boolean isGroupRobot(String robotWxId) {
        if (StringUtil.isBlank(robotWxId)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseResponse(selfRobotService.isGroupRobot(robotWxId), Boolean.class);
        } catch (BizException e) {
            log.warn("是否群机器人失败:" + e.getMessage(), e);
            throw new BizException(e.getCode(), e.getMessage());
        } catch (Exception e) {
            log.error("是否群机器人.[isGroupRobot]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_RES_ERROR, "服务内部错误，请稍后重试");
        } finally {
        }
    }

    /**
     * 是否黑名单
     */
    public Boolean isKickUser(String nickName, String wxGroupId) throws BizException {
        log.info("【是否黑名单,<START>.[nickName]={}, wxGroupId:{}" , nickName, wxGroupId);
        if (StringUtil.isBlank(nickName) || StringUtil.isBlank(wxGroupId)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseResponse(monitorService.isKickUser(nickName, wxGroupId), Boolean.class);
        } catch (BizException e) {
            log.warn("是否黑名单失败:" + e.getMessage(), e);
            throw new BizException(e.getCode(), e.getMessage());
        } catch (Exception e) {
            log.error("是否黑名单.[isKickUser]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_RES_ERROR, "服务内部错误，请稍后重试");
        } finally {
        }
    }

    /**
     * 根据群号获取机器人微信号
     */
    @ParamLog("根据群号获取机器人微信号")
    public String getRobotIdByGroupId(String groupId) throws BizException {
        log.info("【根据群号获取机器人微信号,<START>.[groupId]=" + groupId + "]");
        if (groupId == null) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseResponse(groupMemberService.getRobotIdByGroupId(groupId), String.class);
        } catch (BizException e) {
            log.warn("根据群号获取机器人微信号失败:" + e.getMessage(), e);
            throw new BizException(e.getCode(), e.getMessage());
        } catch (Exception e) {
            log.error("根据群号获取机器人微信号.[getRobotIdByGroupId]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_RES_ERROR, "服务内部错误，请稍后重试");
        } finally {
        }
    }

    @ParamLog("根据群号获取发广告机器人微信号")
    public String getSendAdRobotByGroupId(String groupId) throws BizException{
        log.info("【根据群号获取发广告机器人微信号,<START>.[groupId]=" + groupId + "]");
        if (groupId == null) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseResponse(groupMemberService.getSendAdRobotByGroupId(groupId), String.class);
        } catch (BizException e) {
            log.warn("根据群号获取发广告机器人微信号失败:" + e.getMessage(), e);
            throw new BizException(e.getCode(), e.getMessage());
        } catch (Exception e) {
            log.error("根据群号获取发广告机器人微信号.[getSendAdRobotByGroupId]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_RES_ERROR, "服务内部错误，请稍后重试");
        }
    }

    /**
     * 根据昵称获取微信id
     */
    public List<String> getWxUserIdsByNickName(String nickName) throws BizException {
        log.info("【根据昵称获取微信id,<START>.[nickName]=" + nickName + "]");
        if (StringUtil.isBlank(nickName)) {
            return null;
        }
        try {
            final List<String> strings = ResponseHandleUtil.parseList(groupMemberService.getWxUserIdsByNickName(nickName), String.class);
            log.info("根据昵称获取微信 strings:{}:" ,strings);
            return strings;
        } catch (BizException e) {
            log.warn("根据昵称获取微信id失败:" + e.getMessage(), e);
            throw new BizException(e.getCode(), e.getMessage());
        } catch (Exception e) {
            log.error("根据昵称获取微信id.[getWxUserIdsByNickName]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_RES_ERROR, "服务内部错误，请稍后重试");
        }
    }

    @ParamLog(value = "累计进群人数与今日进群人数", isBefore = false, isAfterReturn = false)
    public Map<String, GroupMemberStatisDTO> listGroupMemberStatisInfo(List<String> weixinGroupIds) throws BizException {
        if (ListUtils.isEmpty(weixinGroupIds)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseMapResponse(groupMemberService.mapGroupMemberStatisInfo(weixinGroupIds), String.class, GroupMemberStatisDTO.class);
        } catch (Exception e) {
            log.error("获取累计进群人数与今日进群人数.[listGroupMemberStatisInfo]:" + e.getMessage(), e);
        }
        return null;
    }

    public Map<String, Integer> mapGroupMemberCount(List<String> weixinGroupIds) throws BizException {
        if (ListUtils.isEmpty(weixinGroupIds)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseMapResponse(groupMemberService.mapGroupMemberCount(weixinGroupIds), String.class, Integer.class);
        } catch (Exception e) {
            log.error("获取群成员数量.[mapGroupMemberCount]:" + e.getMessage(), e);
        }
        return null;
    }

    @ParamLog(value = "群分类累计进群人数与今日进群人数", isBefore = false, isAfterReturn = false)
    public Map<Long, Long> getclassifyMemberCount(List<Long> classifyIds) throws BizException {
        if (ListUtils.isEmpty(classifyIds)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseMapResponse(groupMemberService.mapGroupClassifyStatisInfo(classifyIds), Long.class, Long.class);
        } catch (Exception e) {
            log.error("群分类累计进群人数与今日进群人数.[getclassifyMemberCount]:" + e.getMessage(), e);
        }
        return null;
    }

    @ParamLog(value = "活跃人数与总发言数", isBefore = false, isAfterReturn = false)
    public Map<Long, GroupChatCountDTO> getChatCountByGroup(List<Long> groupQrcodeIds, Long bookGroupId) throws BizException {
        if (ListUtils.isEmpty(groupQrcodeIds)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseMapResponse(messageService.getChatCountByGroup(groupQrcodeIds, bookGroupId), Long.class, GroupChatCountDTO.class);
        } catch (Exception e) {
            log.error("获取活跃人数与总发言数.[getChatCountByGroup]:" + e.getMessage(), e);
        }
        return null;
    }

    @ParamLog(value = "获取退群率", isBefore = false, isAfterReturn = false)
    public Map<String, BigDecimal> mapOutGroupRate(List<String> wxGroupIds) throws BizException {
        if (ListUtils.isEmpty(wxGroupIds)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseMapResponse(groupMemberService.mapOutGroupRate(wxGroupIds), String.class, BigDecimal.class);
        } catch (Exception e) {
            log.error("获取退群率失败.[mapOutGroupRate]:" + e.getMessage(), e);
        }
        return null;
    }

    @ParamLog(value = "上传群二维码时根据群ID添加群管理员（群主，机器人等）")
    public void addGroupManagers(String wxGroupId, String altId) throws BizException {
        try {
            groupMemberService.addGroupManagers(wxGroupId, altId);
        } catch (Exception e) {
            log.error("上传群二维码时根据群ID添加群管理员（群主，机器人等）失败.[addGroupManagers]:" + e.getMessage(), e);
        }
    }

    @ParamLog(value = "获取所有机器人微信号")
    public List<String> listAllRobotWxId() throws BizException {
        try {
            List<String> wxids = ResponseHandleUtil.parseListResponse(groupMemberService.listAllRobotWxId(), String.class);
            return wxids;
        } catch (Exception e) {
            log.error("获取所有机器人微信号失败.[listAllRobotWxId]:" + e.getMessage(), e);
        }
        return null;
    }

    @ParamLog(value = "设置第一个关键词回复")
    public void addFirstRobotReplyRecord(RobotReplyDTO robotReplyDTO) throws BizException {
        try {
            groupMemberService.addFirstRobotReplyRecord(robotReplyDTO);
        } catch (Exception e) {
            log.error("设置第一个关键词回复失败.[addFirstRobotReplyRecord]:" + e.getMessage(), e);
        }
    }

    @ParamLog(value = "获取机器人信息")
    public GroupRobotDTO getRobotInfoByWxUserId(String wxRobotId) throws BizException {
        try {
            return ResponseHandleUtil.parseResponse(groupMemberService.getRobotInfoByWxUserId(wxRobotId), GroupRobotDTO.class);
        } catch (Exception e) {
            log.error("获取机器人信息失败.[getRobotInfoByWxUserId]:" + e.getMessage(), e);
        }
        return null;
    }

    /**
     * 根据群号获取群主微信号
     */
    public String getMasterIdByGroupId(String groupId) throws BizException {
        log.info("【根据群号获取群主微信号,<START>.[groupId]=" + groupId + "]");
        String masterId = null;
        if (groupId == null) {
            return null;
        }
        try {
            masterId = ResponseHandleUtil.parseResponse(groupMemberService.getMasterIdByGroupId(groupId), String.class);
            return masterId;
        } catch (BizException e) {
            log.warn("根据群号获取群主微信号失败:" + e.getMessage(), e);
            throw new BizException(e.getCode(), e.getMessage());
        } catch (Exception e) {
            log.error("根据群号获取群主微信号.[getMasterIdByGroupId]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_RES_ERROR, "服务内部错误，请稍后重试");
        }
    }

    @ParamLog(value = "最近7天活跃人数")
    public Map<Long, Integer> get7DayActiveUserCountByClassify(List<Long> classifyIds) throws BizException {
        Map<Long, Integer> map = new HashMap<>();
        try {
            map = ResponseHandleUtil.parseMapResponse(messageService.get7DayActiveUserCountByClassify(classifyIds), Long.class, Integer.class);
        } catch (Exception e) {
            log.error("获取最近7天活跃人数失败.[get7DayActiveUserCountByClassify]:" + e.getMessage(), e);
        }
        if (map == null) {
            return new HashMap<>();
        }
        return map;
    }


    @ParamLog(value = "根据群id集合批量获取发消息的小号")
    public Map<String, String> getSendDailyRobotByGroupIds(List<String> weixinIds) throws BizException {
        Map<String, String> map = new HashMap<>();
        for (String weixinId:weixinIds){
            map.put(weixinId,"wxid_mxrau68qs7ou22");
        }
        try {
             map = ResponseHandleUtil.parseMapResponse(groupMemberService.getSendDailyRobotByGroupIds(weixinIds), String.class, String.class);
        } catch (Exception e) {
            log.error("根据群id集合批量获取发消息的小号.[getRobotIdByWeixinIdBatch]:" + e.getMessage(), e);
        }
        if (map == null) {
            return new HashMap<>();
        }
        return map;
    }

    @ParamLog(value = "根据群id集合最近7天活跃人数")
    public Map<Long,Integer> get7DayActiveUserCountByQrcode(List<Long> qrcodeIds) {
        Map<Long, Integer> map = new HashMap<>();
        try {
            map = ResponseHandleUtil.parseMapResponse(messageService.get7DayActiveUserCountByQrcode(qrcodeIds), Long.class, Integer.class);
        } catch (Exception e) {
            log.error("根据群id集合最近7天活跃人数.[get7DayActiveUserCountByQrcode]:" + e.getMessage(), e);
        }
        if (map == null) {
            return new HashMap<>();
        }
        return map;
    }

    @ParamLog("根据用户微信ID获取用户信息")
    public GroupUserDTO getWxUserInfoByWxUserId(String wxUserId) {
        GroupUserDTO dto = new GroupUserDTO();
        try {
            dto = ResponseHandleUtil.parseResponse(groupMemberService.getWxUserInfoByWxId(wxUserId), GroupUserDTO.class);
        } catch (Exception e) {
            log.error("根据用户微信ID获取用户信息.[getWxUserInfoByWxId]:" + e.getMessage(), e);
        }
        return dto;
    }

    @ParamLog(value = "获取可用机器人")
    public SelfRobotDTO getAvailableRobot(Long wechatUserId, Integer largeTemplet, Long classifyId) {
        SelfRobotDTO selfRobotDTO = null;
        try {
            selfRobotDTO = ResponseHandleUtil.parseResponse(selfRobotService.getAvailableRobot(wechatUserId, largeTemplet, classifyId), SelfRobotDTO.class);
        } catch (Exception e) {
            log.error("获取可用机器人.[getAvailableRobot]:wechatUserId：{}，largeTemplet：{}，classifyId：{}",wechatUserId,largeTemplet,classifyId);
        }
        return selfRobotDTO;
    }

    @ParamLog(value = "根据群id集合最近7天群活跃度")
    public Map<Long,Integer> get7DayActiveCountByQrcode(List<Long> qrcodeIds) {
        Map<Long, Integer> map = new HashMap<>();
        try {
            map = ResponseHandleUtil.parseMapResponse(messageService.get7DayActiveCountByQrcode(qrcodeIds), Long.class, Integer.class);
        } catch (Exception e) {
            log.error("根据群id集合最近7天群活跃度.[get7DayActiveCountByQrcode]:" + e.getMessage(), e);
        }
        if (map == null) {
            return new HashMap<>();
        }
        return map;
    }

    @ParamLog(value = "获取可用机器人")
    public SelfRobotDTO getAvailableRobotByBookGroup(AvailableRobotParamDTO availableRobotParamDTO) {
        SelfRobotDTO selfRobotDTO = null;
        try {
            selfRobotDTO = ResponseHandleUtil.parseResponse(selfRobotService.getAvailableRobotByBookGroup(availableRobotParamDTO), SelfRobotDTO.class);
        } catch (Exception e) {
            log.error("获取可用机器人.[getAvailableRobotByBookGroup]获取参数为:{}",availableRobotParamDTO);
        }
        return selfRobotDTO;
    }

    @ParamLog("1v1入群-用户基本信息/发言统计")
    public Map<String, UserChatCountDTO> getUserChatInfoByUserIdRobotId(List<UserRobotDTO> robotDTOList) {
        Map<String, UserChatCountDTO> map = new HashMap<>();
        try {
            map = ResponseHandleUtil.parseMapResponse(selfRobotService.getUserChatInfoByUserIdRobotId(robotDTOList), String.class, UserChatCountDTO.class);
        } catch (Exception e) {
            log.error("获取用户基本信息/发言统计失败" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("获取群消息数量")
    public Map<String, GroupStatistics> getGroupMessageStatistics4AdBrand(List<BrandParamDTO> paramDTOList) {
        Map<String, GroupStatistics> map = new HashMap<>();
        try {
            map = ResponseHandleUtil.parseMapResponse(messageService.getGroupStatistics4AdBrand(paramDTOList), String.class, GroupStatistics.class);
        } catch (Exception e) {
            log.error("获取群消息数量.[get7DayActiveCountByQrcode]:" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("获取社群码扫码次数/人数")
    public Map<Long, GroupUserCountDTO> getScanCountByGroup(List<Long> bookGroupIds, String monthDate) {
        Map<Long, GroupUserCountDTO> map = new HashMap<>();
        if (ListUtils.isEmpty(bookGroupIds)){
            return map;
        }
        try {
            map = ResponseHandleUtil.parseMapResponse(groupMemberService.getScanCountByGroup(bookGroupIds, monthDate), Long.class, GroupUserCountDTO.class);

        } catch (Exception e) {
            log.error("获取社群码扫码次数/人数.[getScanCountByGroup]失败" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("获取社群码累计进群人数")
    public Map<Long, GroupUserCountDTO> mapBookGroupJoinUserCount(List<Long> bookGroupIds, String monthDate) {
        Map<Long, GroupUserCountDTO> map = new HashMap<>();
        if (ListUtils.isEmpty(bookGroupIds)){
            return map;
        }
        try {
            map = ResponseHandleUtil.parseMapResponse(groupMemberService.mapBookGroupJoinUserCount(bookGroupIds, monthDate), Long.class, GroupUserCountDTO.class);

        } catch (Exception e) {
            log.error("获取社群码累计进群人数.[mapBookGroupJoinUserCount]失败" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("查询链接发送次数")
    public Map<String, Integer> getLinkSendCount(List<LinkGroupParamDTO> paramDTOList) {
        Map<String, Integer> map = new HashMap<>();
        try {
            map = ResponseHandleUtil.parseMapResponse(messageService.getLinkSendCount(paramDTOList), String.class, Integer.class);

        } catch (Exception e) {
            log.error("查询链接发送次数.[getLinkSendCount]:" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("查询小号信息")
    public GroupRobotDTO getGroupRobotByWxId(String altId) {
        GroupRobotDTO groupRobotDTO = new GroupRobotDTO();
        try {
            groupRobotDTO = ResponseHandleUtil.parseResponse(groupMemberService.getGroupRobotByWxId(altId), GroupRobotDTO.class);
        } catch (Exception e) {
            log.error("查询小号信息.[getGroupRobotByWxId]:" + e.getMessage(), e);
        }
        return groupRobotDTO;
    }

    @ParamLog("根据群id集合查最后发言时间")
    public Map<String, Date> getChatLastTimeByGroup(List<String> groupId) {
        Map<String, Date> map = new HashMap<>();
        try {
            map = ResponseHandleUtil.parseMapResponse(messageService.getChatLastTimeByGroup(groupId), String.class, Date.class);
        } catch (Exception e) {
            log.error("根据群id集合查最后发言时间.[getChatLastTimeByGroup]:" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("获取所有特殊出版社")
    public List<Long> getAllAgentId() {
        List<Long> agentIds = new ArrayList<>();
        try {
            agentIds = ResponseHandleUtil.parseList(selfRobotService.getAllAgentId(), Long.class);
        } catch (Exception e) {
            log.error("查询小号信息.[getGroupRobotByWxId]:" + e.getMessage(), e);
        }
        return agentIds;
    }

    @ParamLog("根据大类拿所有小号id集合")
    public List<String> getRobotListByLargeTemplet(Integer largeTemplet) {
        List<String> altIds = new ArrayList<>();
        if (largeTemplet == null) {
            return altIds;
        }
        try {
            altIds = ResponseHandleUtil.parseList(selfRobotService.getRobotListByLargeTemplet(largeTemplet), String.class);
        } catch (Exception e) {
            log.error("根据大类拿所有小号id集合.[getRobotListByLargeTemplet]:" + e.getMessage(), e);
        }
        return altIds;
    }

    @ParamLog("批量获取小号名称信息")
    public Map<String, RobotBaseInfoDTO> mapRobotInfo(List<String> altIds) {
        Map<String, RobotBaseInfoDTO> map = new HashMap<>();
        if (ListUtils.isEmpty(altIds)){
            return map;
        }
        try {
            map = ResponseHandleUtil.parseMapResponse(selfRobotService.mapRobotInfo(altIds), String.class, RobotBaseInfoDTO.class);
        } catch (Exception e) {
            log.error("批量获取小号名称信息.[mapRobotInfo]:" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("社群书群消息量")
    public Map<Long, GroupMsgCountDTO> mapBookGroupMsgCount(List<Long> bookGroupIds) {
        Map<Long, GroupMsgCountDTO> map = new HashMap<>();
        try {
            map = ResponseHandleUtil.parseMapResponse(messageService.mapBookGroupMsgCount(bookGroupIds), Long.class, GroupMsgCountDTO.class);
        } catch (Exception e) {
            log.error("社群书群消息量.[mapBookGroupMsgCount]:" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("每个用户接收消息数量")
    public Map<String, Integer> mapReceiveMsgCountByIds(List<String> wxUserIds) {
        Map<String, Integer> map = new HashMap<>();
        try {
            map = ResponseHandleUtil.parseMapResponse(selfRobotService.mapReceiveMsgCountByIds(wxUserIds), String.class, Integer.class);
        } catch (Exception e) {
            log.error("每个用户接收消息数量.[mapReceiveMsgCountByIds]:" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("出版社对应的机器人消息量")
    public Map<Long, Integer> mapAgentMsgCountByRobotIdList(Map<Long, List<String>> agentRobotsMap) {
        Map<Long, Integer> map = new HashMap<>();
        if(agentRobotsMap.isEmpty()) {
            return map;
        }
        try {
            map = ResponseHandleUtil.parseMapResponse(selfRobotService.mapAgentMsgCountByRobotIdList(agentRobotsMap), Long.class, Integer.class);
        } catch (Exception e) {
            log.error("出版社对应的机器人消息量.[mapAgentMsgCountByRobotIdList]:" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("出版社定制小号数")
    public Map<Long, Integer> mapSpecialAgentRobotCount(List<Long> agentIds) {
        Map<Long, Integer> map = new HashMap<>();
        if(CollectionUtils.isEmpty(agentIds)) {
            return map;
        }
        try {
            map = ResponseHandleUtil.parseMapResponse(selfRobotService.mapSpecialAgentRobotCount(agentIds), Long.class, Integer.class);
        } catch (Exception e) {
            log.error("出版社定制小号数.[mapSpecialAgentRobotCount]:" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("批量获取小号和用户的好友关系")
    public List<AltAndUserResultDTO> listAltAndUserRelationship(List<AltAndUserDTO> altAndUserDTOS) {
        List<AltAndUserResultDTO> list = new ArrayList<>();
        if (CollectionUtils.isEmpty(altAndUserDTOS)) {
            return list;
        }
        try {
            list = ResponseHandleUtil.parseListResponse(selfRobotService.listAltAndUserRelationship(altAndUserDTOS), AltAndUserResultDTO.class);
        } catch (Exception e) {
            log.error("批量获取小号和用户的好友关系.[listAltAndUserRelationship]:" + e.getMessage(), e);
        }
        return list;
    }


    @ParamLog("根据用户id或昵称模糊查询")
    public List<String> getByUserQuery(String userQuery) {
        List<String> list = new ArrayList<>();
        try {
            list = ResponseHandleUtil.parseListResponse(groupMemberService.getByUserQuery(userQuery), String.class);

        } catch (Exception e) {
            log.error("根据用户id或昵称模糊查询.[getByUserQuery]失败" + e.getMessage(), e);
        }
        return list;
    }

    @ParamLog("根据qq用户id或昵称模糊查询")
    public List<String> getByQqUserQuery(String userQuery) {
        List<String> list = new ArrayList<>();
        try {
            list = ResponseHandleUtil.parseListResponse(groupMemberService.getByQqUserQuery(userQuery), String.class);

        } catch (Exception e) {
            log.error("根据qq用户id或昵称模糊查询.[getByQqUserQuery]失败" + e.getMessage(), e);
        }
        return list;
    }

    @ParamLog("批量获取用户信息")
    public Map<String, GroupUserDTO> mapWxUserInfoByWxIdList(List<String> wxUserIds) {
        Map<String, GroupUserDTO> map = new HashMap<>();
        if(ListUtils.isEmpty(wxUserIds)){
            return new HashMap<>();
        }
        try {
            map = ResponseHandleUtil.parseMapResponse(groupMemberService.mapWxUserInfoByWxIdList(wxUserIds), String.class, GroupUserDTO.class);

        } catch (Exception e) {
            log.error("批量获取用户信息.[mapWxUserInfoByWxIdList]失败" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("批量获取qq用户信息")
    public Map<String, GroupUserDTO> mapQqUserInfoByWxIdList(List<String> qqUserIds) {
        Map<String, GroupUserDTO> map = new HashMap<>();
        if(ListUtils.isEmpty(qqUserIds)){
            return new HashMap<>();
        }
        try {
            map = ResponseHandleUtil.parseMapResponse(groupMemberService.mapQqUserInfoByQqIdList(qqUserIds), String.class, GroupUserDTO.class);

        } catch (Exception e) {
            log.error("批量获取qq用户信息.[mapQqUserInfoByWxIdList]失败" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("批量获取小号信息")
    public Map<String, GroupUserDTO> mapRobotInfoByIdList(List<String> wxIdList){
        Map<String, GroupUserDTO> map = new HashMap<>();
        try {
            map = ResponseHandleUtil.parseMapResponse(groupMemberService.mapRobotInfoByIdList(wxIdList), String.class, GroupUserDTO.class);

        } catch (Exception e) {
            log.error("批量获取小号信息.[]失败" + e.getMessage(), e);
        }
        return map;
    }

    @ParamLog("根据小号类型获取小号id")
    public List<String> getSelfRobotByRobotType(Integer robotType) {
        List<String> ids = new ArrayList<>();
        try {
            ids = ResponseHandleUtil.parseList(selfRobotService.getSelfRobotByRobotType(robotType),String.class);
        }catch (Exception e){
            log.error("[selfRobotService.getSelfRobotByRobotType]调用失败" + e.getMessage(), e);
        }
        return ids;
    }

    @ParamLog("获取小号所有好友")
    public List<String> getFriendByRobotId(String altId, Integer altType) {
        List<String> ids = new ArrayList<>();
        try {
            ids = ResponseHandleUtil.parseList(selfRobotService.getFriendByRobotIdAndType(altId,altType), String.class);
        }catch (Exception e){
            log.error("[selfRobotService.getFriendByRobotId]调用失败" + e.getMessage(), e);
        }
        return ids;
    }

    @ParamLog("分页查小号好友id")
    public PageBeanNew<String> listPageFriend(Integer currentPage, Integer numPerPage, String robotId, String name, Integer groupRobotType){
        PageBeanNew<String> pageBeanNew = null;
        FriendParamDTO friendParamDTO = new FriendParamDTO();
        friendParamDTO.setCurrentPage(currentPage);
        friendParamDTO.setNumPerPage(numPerPage);
        friendParamDTO.setRobotId(robotId);
        friendParamDTO.setName(name);
        friendParamDTO.setGroupRobotType(groupRobotType);
        try {
            ResponseEntity responseEntity = selfRobotService.listPageFriendId(friendParamDTO);
            Object object = ResponseHandleUtil.parseResponse(responseEntity);
            ObjectMapper mapper = new ObjectMapper();
            pageBeanNew = mapper.readValue(JSONUtils.toJsonString(object), PageBeanNew.class);
        } catch (Exception e){
            log.error("[selfRobotService.listPageFriendId]调用失败" + e.getMessage(), e);
        }
        return pageBeanNew;
    }

    @ParamLog(value = "根据大类获取个人号", isAfterReturn = false)
    public List<RobotBaseInfoDTO> getRobotInfoByTemplet(Integer largeTemplet){
        List<RobotBaseInfoDTO> list = new ArrayList<>();
        try {
            list = ResponseHandleUtil.parseList(selfRobotService.getRobotInfoByTemplet(largeTemplet), RobotBaseInfoDTO.class);
        }catch (Exception e){
            log.error("[selfRobotService.getRobotInfoByTemplet]调用失败" + e.getMessage(), e);
        }
        return list;
    }

    @ParamLog(value = "发送登录二维码邮件")
    public void sendQrcodeLoginEmail(String wxId){
        try {
            groupMemberService.sendQrcodeLoginEmail(wxId);
        }catch (Exception e){
            log.error("[groupMemberService.sendQrcodeLoginEmail]发送登录二维码邮件调用失败" + e.getMessage(), e);
        }
    }

    @ParamLog("获取用户服务状态")
    public Integer getServiceStateByRobotUser(String robotId, String wxUserId){
        Integer serviceState = 0;
        try {
            serviceState = ResponseHandleUtil.parseResponse(selfRobotService.getServiceStateByRobotUser(robotId, wxUserId), Integer.class);

        }catch (Exception e){
            log.error("[selfRobotService.getServiceStateByRobotUser]调用失败" + e.getMessage(), e);
        }
        return serviceState;
    }

    @ParamLog(value = "获取机器人信息")
    public GroupRobotDTO getGroupRobotByRobotId(String robotId) throws BizException {
        try {
            return ResponseHandleUtil.parseResponse(selfRobotService.getGroupRobotByRobotId(robotId), GroupRobotDTO.class);
        } catch (Exception e) {
            log.error("获取机器人信息失败.[getGroupRobotByRobotId]:" + e.getMessage(), e);
        }
        return null;
    }

    public void sendMessage(String baseVO) throws BizException {
        try {
            selfRobotService.sendMessage(baseVO);
        } catch (Exception e) {
            log.error("机器人给用户发送消息失败.[sendMessage]:" + e.getMessage(), e);
        }
    }

    public Map<String, GroupUserDTO> mapWxUserInfoByWxIdListAndType(List<String> wechatUserIds, Integer groupRobotType) {
        Map<String, GroupUserDTO> map = new HashMap<>();
        try {
            map = ResponseHandleUtil.parseMapResponse(groupMemberService.mapWxUserInfoByWxIdListAndType(wechatUserIds,groupRobotType), String.class, GroupUserDTO.class);

        } catch (Exception e) {
            log.error("批量获取用户信息.[mapWxUserInfoByWxIdList]失败" + e.getMessage(), e);
        }
        return map;
    }

    public void sendMessage4QQ(PrivateMsgSendVO privateMsgSendVO) {
        try {
            CoolQSDK.sendPrivateMsg(privateMsgSendVO);
        } catch (Exception e) {
            log.error("qq机器人给用户发送消息失败.[sendMessage]:" + e.getMessage(), e);
        }
    }

    public void sendMessageToMiniUser(SendMessageDTO sendMessageDTO) {
        try {
            selfRobotService.sendMessageToMiniUser(sendMessageDTO);
        } catch (Exception e) {
            log.error("给指定分类小程序用户发送站内信失败.[sendMessage]:" + e.getMessage(), e);
        }
    }
}
