package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.AppTouchRecordDao;
import com.pcloud.book.group.dto.AppStatisticsDTO;
import com.pcloud.book.group.entity.AppTouchRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/5/29 17:43
 **/
@Component("appTouchRecordDao")
public class AppTouchRecordDaoImpl extends BaseDaoImpl<AppTouchRecord> implements AppTouchRecordDao {


    @Override
    public Long getCountByBokkGroupId(Long bookGroupId, String type) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId",bookGroupId);
        map.put("type",type);
        return this.getSqlSession().selectOne(this.getStatement("getCountByBokkGroupId"), map);
    }

    @Override
    public List<AppStatisticsDTO> getAppTouchStatistics(Map<String, Object> map) {
        return this.getSqlSession().selectList(this.getStatement("getAppTouchStatistics"), map);
    }
}
