package com.pcloud.book.rightsSetting.biz;

import com.pcloud.book.rightsSetting.dto.FillRightsSettingAppletsDTO;
import com.pcloud.book.rightsSetting.dto.RightsSettingDto;
import com.pcloud.book.rightsSetting.entity.BaseTempletClassify;
import com.pcloud.book.rightsSetting.entity.RightsSetting;
import com.pcloud.book.rightsSetting.entity.RightsSettingClassify;
import com.pcloud.book.rightsSetting.entity.RightsSettingItem;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

public interface RightsSettingBiz {
    Long addRightsSetting(RightsSetting rightsSetting);

    void setClassifyAndLabel(BaseTempletClassify baseTempletClassify);

    void deleteRightsSetting(Long id);

    void updateRightsSetting(RightsSetting rightsSetting);

    RightsSetting getRightsSetting(Long id);

    PageBeanNew<RightsSettingDto> listRightsSettingPage(Integer currentPage, Integer numPerPage, RightsSetting rightsSetting);

    RightsSettingDto getByLabel(Long firstClassify,Long secondClassify,Long gradeLabelId,Long subjectLabelId);

    Integer getUserCount();

    /**
     * 批量新增每周/长期权益
     * @param rightsSettingItemList
     * @param rightsSettingId
     */
    void batchInsertRightsSettingItem(List<RightsSettingItem> rightsSettingItemList, Long rightsSettingId,String rightsType);

    /**
     * 每周/长期权益查询
     * @param rightsSettingId
     * @param rightsType
     * @return
     */
    List<RightsSettingItem> getItemsByRightsSettingId(Long rightsSettingId, String rightsType);

    /**
     * 小程序首页权益查询
     * @param bookId
     * @param adviserId
     * @param channelId
     * @return
     */
    RightsSettingDto getRightsSettingByBookId4AppletHome(Long bookId, Long adviserId, Long channelId);

    /**
     * 小程序首页本周/长期权益查询
     * @param rightsSettingId
     * @param wechatUserId
     * @param rightsType
     * @return
     */
    RightsSettingDto getItemByRightsSettingId4AppletHome(Long rightsSettingId, Long wechatUserId, String rightsType);

    /**
     * 每周/长期权益查询--小程序
     * @param rightsSettingId
     * @param rightsType
     * @param wechatUserId
     * @return
     */
    List<RightsSettingItem> getItemsByRightsSettingId4Applet(Long rightsSettingId, String rightsType, Long wechatUserId);

    /**
     * 查所有权益分类
     * @param rightsType
     * @return
     */
    List<RightsSettingClassify>getAllRightsClassify(String rightsType);

    RightsSetting getRightsSettingRightsNowItems(Long rightsSettingId, Long wechatUserId);

    RightsSetting getRightsSettingGiftCoupons(Long rightsSettingId, Long wechatUserId);

    FillRightsSettingAppletsDTO getFillRightsSettingApplets(Long rightsSettingId, Long wechatUserId);
}
